<?php

/*
|--------------------------------------------------------------------------
| PHP Display Errors Configuration
|--------------------------------------------------------------------------
|
| Since Laravel intercepts and displays all errors with a detailed stack
| trace, we can turn off the display_errors ini directive. However, you
| may want to enable this option if you ever run into a dreaded white
| screen of death, as it can provide some clues.
| More detailed config about errors managing are available in app/config/error.php
|
*/

ini_set('display_errors', 'On');

$config_app = require_once path('public') . 'config.app.php';

Laravel\Event::listen(Laravel\Config::loader, function($bundle, $file) use ($config_app) {
	if($bundle !== 'application') {
		return Laravel\Config::file($bundle, $file);
	}

	$load = Laravel\Config::file($bundle, $file);

	switch($file) {
		case 'application':
			$config = array(
				'attached' => $config_app['attached'],
				'editor' => $config_app['editor'],
				'key' => $config_app['key'],
				'index' => !$config_app['mod_rewrite'] ? 'index.php' : '',
				'mail' => $config_app['mail'],
				'my_bugs_app'=>$config_app['my_bugs_app'],
				'timezone' => $config_app['timezone'],
				'url' => isset($config_app['url']) ? $config_app['url'] : '',
				'pref' => array('percent' => $config_app['Percent'] ?? array (100,0,10,80,100),
									 'duration' => $config_app['duration'] ?? 30,
									 'prioritycolors' => $config_app['PriorityColors'] ?? array("black","Orchid","Cyan","Lime","orange","red"),
									 'todoitems' => $config_app['TodoNbItems'] ?? 25,
									 'tempsfait' => $config_app['TempsFait'] ?? 0,
									 'partjour' => $config_app['PartJour'] ?? array('00:00','06:00','12:00','18:00', '23:59')
				),
			);
			$load =  $config + $load;
			break;

		case 'database':
			$config['connections'][$config_app['database']['driver']] = array_merge(array(
				'charset' => 'utf8',
				'prefix' => ''
			), $config_app['database']);
			$config['default'] = $config_app['database']['driver'];
			$load = $config + $load;
			break;
	}

	return $load;
});

/*
|--------------------------------------------------------------------------
| Register Class Aliases
|--------------------------------------------------------------------------
|
| Aliases allow you to use classes without always specifying their fully
| namespaced path. This is convenient for working with any library that
| makes a heavy use of namespace for class organization. Here we will
| simply register the configured class aliases.
|
*/

$aliases = Laravel\Config::get('application.aliases');

Laravel\Autoloader::$aliases = $aliases;

/*
|--------------------------------------------------------------------------
| Auto-Loader Mappings
|--------------------------------------------------------------------------
|
| Registering a mapping couldn't be easier. Just pass an array of class
| to path maps into the "map" function of Autoloader. Then, when you
| want to use that class, just use it. It's simple!
|
*/

Autoloader::map(array(
	'Base_Controller' => path('app').'controllers/base.php',
));

/*
|--------------------------------------------------------------------------
| Auto-Loader Directories
|--------------------------------------------------------------------------
|
| The Laravel auto-loader can search directories for files using the PSR-0
| naming convention. This convention basically organizes classes by using
| the class namespace to indicate the directory structure.
|
*/

Autoloader::directories(array(
	path('app').'models',
	path('app').'libraries',
));

/*
|--------------------------------------------------------------------------
| Laravel View Loader
|--------------------------------------------------------------------------
|
| The Laravel view loader is responsible for returning the full file path
| for the given bundle and view. Of course, a default implementation is
| provided to load views according to typical Laravel conventions but
| you may change this to customize how your views are organized.
|
*/

Event::listen(View::loader, function($bundle, $view) {
	return View::file($bundle, $view, Bundle::path($bundle).'views');
});

/*
|--------------------------------------------------------------------------
| Laravel Language Loader
|--------------------------------------------------------------------------
|
| The Laravel language loader is responsible for returning the array of
| language lines for a given bundle, language, and "file". A default
| implementation has been provided which uses the default language
| directories included with Laravel.
|
*/

Event::listen(Lang::loader, function($bundle, $language, $file) {
	$user = Auth::user() ;
	if( ! is_null($user) && $user->language != '')
		$language = $user->language ;

	return Lang::file($bundle, $language, $file);
});

/*
|--------------------------------------------------------------------------
| Attach The Laravel Profiler
|--------------------------------------------------------------------------
|
| If the profiler is enabled, we will attach it to the Laravel events
| for both queries and logs. This allows the profiler to intercept
| any of the queries or logs performed by the application.
|
*/

if (Config::get('application.profiler')) {
	Profiler::attach();
}

/*
|--------------------------------------------------------------------------
| Enable The Blade View Engine
|--------------------------------------------------------------------------
|
| The Blade view engine provides a clean, beautiful templating language
| for your application, including syntax for echoing data and all of
| the typical PHP control structures. We'll simply enable it here.
|
*/

Blade::sharpen();

/*
|--------------------------------------------------------------------------
| Set The Default Timezone
|--------------------------------------------------------------------------
|
| We need to set the default timezone for the application. This controls
| the timezone that will be used by any of the date methods and classes
| utilized by Laravel or your application. The timezone may be set in
| your application configuration file.
|
*/

date_default_timezone_set(Config::get('application.timezone'));

/*
|--------------------------------------------------------------------------
| Start / Load The User Session
|--------------------------------------------------------------------------
|
| Sessions allow the web, which is stateless, to simulate state. In other
| words, sessions allow you to store information about the current user
| and state of your application. Here we'll just fire up the session
| if a session driver has been configured.
|
*/

if ( ! Request::cli() and Config::get('session.driver') !== '') {
	Session::load();
}
