<?php
\Schema::create('permissions', function ($table) {
  $table->increments('id');
  $table->string('permission', 255)->default('');
  $table->text('description');
  $table->string('auto_has', 255)->default('');
});

\DB::table('permissions')->insert(array(
	array('id'=>1, 'permission'=>'issue-view', 	  'description'=>'View issues in project assigned to', 'auto_has'=>''),
	array('id'=>2, 'permission'=>'issue-create',   'description'=>'Create issues in projects assigned to', 'auto_has'=>''),
	array('id'=>3, 'permission'=>'issue-comment',  'description'=> 'Comment in issues in projects assigned to', 'auto_has'=>'1'),
	array('id'=>4, 'permission'=>'issue-modify',   'description'=>'Modify issues in projects assigned to', 'auto_has'=>'1'),
	array('id'=>6, 'permission'=>'administration', 'description'=> 'Administration tools, such as user management and application settings.', 'auto_has'=>''),
	array('id'=>9, 'permission'=>'project-create', 'description'=> 'Create a new project', 'auto_has'=>''),
	array('id'=>10,'permission'=>'project-modify', 'description'=> 'Modify a project assigned to', 'auto_has'=>''),
	array('id'=>11,'permission'=>'project-all', 	  'description'=>'View, modify all projects and issues', 'auto_has'=>'1,2,3,4')
));


