<?php return array("
CREATE TABLE `activity` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) DEFAULT NULL,
  `DE` varchar(255) DEFAULT NULL,
  `EN` varchar(255) DEFAULT NULL,
  `ES` varchar(255) DEFAULT NULL,
  `FR` varchar(255) DEFAULT NULL,
  `IT` varchar(255) DEFAULT NULL,
  `RU` varchar(255) DEFAULT NULL,
  `ZH_CN` varchar(255) DEFAULT NULL,
  `ZH_TW` varchar(255) DEFAULT NULL,
  `activity` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
","
CREATE TABLE `following` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `project_id` int(11) NOT NULL,
  `issue_id` int(11) NOT NULL,
  `project` tinyint(2) NOT NULL DEFAULT 0,
  `attached` tinyint(2) NOT NULL DEFAULT 1,
  `tags` tinyint(2) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
","
CREATE TABLE `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `permission` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `auto_has` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
","
CREATE TABLE `projects` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `status` tinyint(2) DEFAULT 1,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `default_assignee` bigint(20) DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
","
CREATE TABLE `projects_issues` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL DEFAULT 1,
  `closed_by` bigint(20) DEFAULT NULL,
  `updated_by` bigint(20) DEFAULT NULL,
  `assigned_to` bigint(20) DEFAULT NULL,
  `project_id` bigint(20) DEFAULT NULL,
  `status` tinyint(2) DEFAULT 1,
  `weight` bigint(20) NOT NULL DEFAULT 1,
  `title` varchar(255) DEFAULT NULL,
  `body` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `start_at` datetime DEFAULT NULL,
  `duration` smallint(3) NOT NULL DEFAULT 30,
  `temps_plan` smallint(4) DEFAULT 30,
  `temps_fact` int(11) DEFAULT 0,
  `temps_paye` int(11) DEFAULT 0,
  `updated_at` datetime DEFAULT NULL,
  `closed_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
","
CREATE TABLE `projects_issues_attachments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `issue_id` bigint(20) DEFAULT NULL,
  `comment_id` bigint(20) DEFAULT 0,
  `uploaded_by` bigint(20) DEFAULT NULL,
  `filesize` bigint(20) DEFAULT NULL,
  `filename` varchar(250) DEFAULT NULL,
  `fileextension` varchar(255) DEFAULT NULL,
  `upload_token` varchar(100) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
","
CREATE TABLE `projects_issues_comments` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) DEFAULT 0,
  `project_id` bigint(20) DEFAULT NULL,
  `issue_id` bigint(20) DEFAULT 0,
  `comment` text DEFAULT NULL,
  `temps_fait` smallint(4) DEFAULT 1,
  `temps_fait_deb` datetime DEFAULT NULL,
  `temps_fait_fin` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
","
CREATE TABLE `projects_issues_tags` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `issue_id` bigint(20) unsigned NOT NULL,
  `tag_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `issue_tag` (`issue_id`,`tag_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
","
CREATE TABLE `projects_links` (
  `id_link` int(11) NOT NULL AUTO_INCREMENT,
  `id_project` int(11) NOT NULL DEFAULT 1,
  `category` enum('dev','git','prod') NOT NULL DEFAULT 'dev',
  `link` varchar(100) NOT NULL,
  `created` date NOT NULL,
  `desactivated` date DEFAULT NULL,
  PRIMARY KEY (`id_link`),
  KEY `id_project_category_desactivated_created` (`id_project`,`category`,`desactivated`,`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
","
CREATE TABLE `projects_users` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT 0,
  `project_id` bigint(20) DEFAULT 0,
  `role_id` bigint(20) DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
","
CREATE TABLE `roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `role` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
","
CREATE TABLE `roles_permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` bigint(11) DEFAULT NULL,
  `permission_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
","
CREATE TABLE `sessions` (
  `id` varchar(40) NOT NULL,
  `last_activity` int(10) NOT NULL,
  `data` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
","
CREATE TABLE `settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
","
CREATE TABLE `tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(255) NOT NULL,
  `DE` varchar(255) NOT NULL DEFAULT '',
  `EN` varchar(255) NOT NULL,
  `ES` varchar(255) NOT NULL,
  `FR` varchar(255) NOT NULL,
  `IT` varchar(255) NOT NULL,
  `RU` varchar(255) NOT NULL,
  `ZH_CN` varchar(255) NOT NULL,
  `ZH_TW` varchar(255) NOT NULL,
  `bgcolor` varchar(50) NOT NULL DEFAULT '#330033',
  `ftcolor` varchar(50) NOT NULL DEFAULT '#FFFFFF',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tags_tag_unique` (`tag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
","
CREATE TABLE `update_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Footprint` varchar(25) DEFAULT NULL,
  `Description` varchar(100) DEFAULT NULL,
  `DteRelease` date DEFAULT NULL,
  `DteInstall` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
","
CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` bigint(20) unsigned NOT NULL DEFAULT 1,
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `firstname` varchar(255) DEFAULT NULL,
  `lastname` varchar(255) DEFAULT NULL,
  `language` varchar(5) DEFAULT NULL,
  `preferences` text DEFAULT 'sidebar=true;orderSidebar=desc;numSidebar=0;template=default',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
","
CREATE TABLE `users_activity` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `item_id` bigint(20) DEFAULT NULL,
  `action_id` bigint(20) DEFAULT NULL,
  `type_id` int(11) DEFAULT NULL,
  `data` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
","
CREATE TABLE `users_dispo` (
  `id_dispo` int(11) NOT NULL AUTO_INCREMENT,
  `id_project` int(11) NOT NULL,
  `id_issue` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `LaDate` date NOT NULL,
  `PartJour` smallint(6) NOT NULL,
  `Par` int(11) NOT NULL,
  `Accepte` enum('oui','non') DEFAULT NULL,
  `AccepteDte` timestamp NULL DEFAULT current_timestamp(),
  `Ajour` timestamp NOT NULL DEFAULT '2000-01-01 00:00:01' ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_dispo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
","
CREATE TABLE `users_todos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `issue_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `status` tinyint(2) DEFAULT 1,
  `weight` bigint(20) DEFAULT 1,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
","
INSERT IGNORE INTO `activity` (`id`, `description`, `EN`,`FR`,`activity`)
VALUES
	(1,'Opened a new issue','Opened a new issue','Nouveau billet créé','create-issue'),
	(2,'Commented on a issue','Commented on a issue','Nouveau commentaire sur un billet','comment'),
	(3,'Closed an issue','Closed an issue','Billet fermé','close-issue'),
	(4,'Reopened an issue','Reopened an issue','Billet rouvert','reopen-issue'),
	(5,'Reassigned an issue','Reassigned an issue','Changement de responsable du billet','reassign-issue'),
	(6,'Updated issue tags','Updated issue tags','Mise à jour des étiquettes','update-issue-tags'),
	(7,'Attached a file to issue','Attached a file to issue','Fichier joint au billet','attached-file'),
	(8,'Move an issue from project A to project B','Move an issue from project A to project B','éplacement d`un billet du projet A vers le projet B',	'ChangeIssue-project'),
	(9,'User starts or stop following issue or project','User starts or stop following issue or project','Un usager a commencé ou cessé de suivre le billet', 'Follow'),
	(10,'Updated an issue','Updated an issue','Mise à jour d`un billet', 'IssueEdit'),
	(11,'Deleted a comment','Deleted a comment','Commentaire supprimé', 'delete_comment'),
	(12,'Edited a comment','Edited a comment','	Commentaire modifié','edit_comment' ),
	(13,'Elapsed time worked on an issue','Elapsed time worked on an issue','Temps de travail d`un ouvrier', 'issue_chrono');
","
INSERT INTO `tags` (`id`, `tag`, `bgcolor`, `ftcolor`, `created_at`, `updated_at`, `EN`,`FR`,`ES`,`DE`,`IT`,`RU`,`ZH_CN`,`ZH_TW` ) VALUES
(1,	'status:open',				'#c43c35','#FFFFFF',	'2013-11-30 11:23:01',	'2013-11-30 11:23:01','status:open',			'État:ouvert',					'Estado: Aberto','','','','',''),
(2,	'status:closed',			'#46A546','#FFFFFF',	'2013-11-30 11:23:01',	'2013-11-30 11:23:01','status:closed',			'État:fermé',					'Estado: Cerrado','','','','',''),
(3,	'type:feature',			'#62cffc','#FFFFFF',	'2013-11-30 11:23:01',	'2013-11-30 11:23:01','type:feature',			'Type: développement',		'Tipo: desarollo','','','','',''),
(4,	'type:bug',					'#f89406','#FFFFFF',	'2013-11-30 11:23:01',	'2013-11-30 11:23:01','type:bug',				'Type: débogage',				'Tipo: debug','','','','',''),
(6,	'resolution:won`t fix',	'#812323','#FFFFFF',	'2013-11-30 11:23:01',	'2013-11-30 11:23:01','resolution:won`t fix','Verdict: impossible :(',	'Deicsion: impossible','','','','',''),
(7,	'resolution:fixed',		'#048383','#FFFFFF',	'2013-11-30 11:23:01',	'2013-11-30 11:23:01','resolution:fixed',		'Verdict: Résolu ! :)',		'Decision: Solucionado','','','','',''),
(8,	'status:testing',			'#FCC307','#FFFFFF',	'2013-11-30 11:23:01',	'2016-11-30 23:11:01','status:testing',		'État: nous testons',		'Estado: haciendo tests','','','','',''),
(9,	'status:inProgress',		'#FF6600','#FFFFFF',	'2016-11-10 23:12:01',	'2016-11-10 23:12:01','status:inProgress',	'État: Progressons',			'Estado: progressamos','','','','','');
","
INSERT INTO `permissions` (`id`, `permission`, `description`, `auto_has`) VALUES
(1,	'issue-view',	'View issues in project assigned to',	NULL),
(2,	'issue-create',	'Create issues in projects assigned to',	'4'),
(3,	'issue-comment',	'Comment in issues in projects assigned to',	'1'),
(4,	'issue-modify',	'Modify issues in projects assigned to',	'3'),
(11,	'project-all',	'View, modify all projects and issues',	'9'),
(6,	'administration',	'Administration tools, such as user management and application settings.',	'11'),
(9,	'project-create',	'Create a new project',	'5,10'),
(10,	'project-modify',	'Modify a project assigned to',	'2,7'),
(5,	'reports-create',	'Can produce reports',	'7'),
(7,	'reports-view',	'Can view already done reports',	NULL);
","
INSERT INTO `roles` (`id`, `name`, `role`, `description`) VALUES
(1,	'Observateur',	'user',	'Les tickets qui lui sont assignés ne sont disponibles qu\'en lecture.'),
(2,	'Développeur',	'developer',	'Peut modifier les tickets qui lui sont assignés'),
(3,	'Gestionnaire',	'manager',	'Peut modifier les tickets de tous les projets et les projets.'),
(4,	'Admin',	'administrator',	'Peut modifier les tickets et les projets. Peut aussi modifier le comportement global de l\'outil Bugs');
","
INSERT INTO `roles_permissions` (`id`, `role_id`, `permission_id`) VALUES
(1,	1,	1),
(2,	1,	2),
(3,	1,	3),
(4,	2,	1),
(5,	2,	2),
(6,	2,	3),
(7,	2,	4),
(8,	3,	11),
(9,	3,	1),
(10,	3,	2),
(11,	3,	3),
(12,	3,	4),
(13,	4,	1),
(14,	4,	2),
(15,	4,	3),
(16,	4,	6),
(17,	4,	9),
(18,	4,	10),
(19,	4,	11),
(20,	4,	4);
","
INSERT INTO `update_history` (`id`, `Footprint`, `Description`, `DteRelease`, `DteInstall`) VALUES
(1,'-------------------------','Version 1.6.0','2017-05-01',NULL),
(2,'Database update via admin','update_v1-1_1.sql','2017-05-10',NULL),
(3,'Database update via admin','update_v1-2_9.sql','2018-06-01',NULL),
(4,'Database update via admin','update_v1-3_1.sql','2018-07-04',NULL),
(5,'Database update via admin','update_v1-3_2.sql','2018-07-05',NULL),
(6,'Database update via login','update_v1-3_3.sql','2018-09-18',NULL),
(7,'Database update via admin','update_v1-8_3a.sql','2018-10-10',NULL),
(8,'Database update via admin','update_v1-8_4a.sql','2019-02-14',NULL),
(9,'Database update via admin','update_v1-8_4b.sql','2019-05-08',NULL),
(10,'Database update via admin','update_v1-8_4d.sql','2019-07-08',NULL),
(11,'Database update via admin','update_v1-8_5af.sql','2020-04-01',NULL),
(12,'Database update via admin','update_v1-8_5t.sql','2020-05-30',NULL),
(13,'Database update via admin','update_v1-8_6e.sql','2020-08-11',NULL),
(14,'Database update via admin','update_v1-8_7a.sql','2020-10-12',NULL),
(15,'Database update via admin','update_v1-8_7ag.sql','2021-04-03',NULL),
(16,'Database update via admin','update_v1-8_7b.sql','2021-05-04',NULL),
(17,'Database update via admin','update_v1-8_7c.sql','2021-06-24',NULL),
(18,'Database update via admin','update_v1-8_7m.sql','2021-07-17',NULL),
(19,'Database update via admin','update_v1-8_7p.sql','2021-07-20',NULL),
(20,'Database update via admin','update_v1-8_7r.sql','2021-09-01',NULL),
(21,'Database update via admin','update_v1-8_7s.sql','2021-10-01',NULL),
(22,'Database update via admin','update_v1-8_7u.sql','2021-12-31',NULL);
" );