<?php

declare (strict_types=1);
namespace ExpressionEngine\Dependency\BaconQrCode\Renderer\RendererStyle;

use ExpressionEngine\Dependency\BaconQrCode\Renderer\Eye\EyeInterface;
use ExpressionEngine\Dependency\BaconQrCode\Renderer\Eye\ModuleEye;
use ExpressionEngine\Dependency\BaconQrCode\Renderer\Module\ModuleInterface;
use ExpressionEngine\Dependency\BaconQrCode\Renderer\Module\SquareModule;
final class RendererStyle
{
    private $module;
    private $eye;
    private $fill;
    private $size;
    private $margin;
    public function __construct(int $size, int $margin = 4, ?ModuleInterface $module = null, ?EyeInterface $eye = null, ?Fill $fill = null)
    {
        $this->size = $size;
        $this->margin = $margin;
        $this->module = $module ?: SquareModule::instance();
        $this->eye = $eye ?: new ModuleEye($this->module);
        $this->fill = $fill ?: Fill::default();
    }
    public function withSize(int $size): self
    {
        $style = clone $this;
        $style->size = $size;
        return $style;
    }
    public function withMargin(int $margin): self
    {
        $style = clone $this;
        $style->margin = $margin;
        return $style;
    }
    public function getSize(): int
    {
        return $this->size;
    }
    public function getMargin(): int
    {
        return $this->margin;
    }
    public function getModule(): ModuleInterface
    {
        return $this->module;
    }
    public function getEye(): EyeInterface
    {
        return $this->eye;
    }
    public function getFill(): Fill
    {
        return $this->fill;
    }
}
