@extends('layouts.front')

@push('css')

    @if ($page->slug === 'privacy-policy')
        <style>
        <style>
          .privacy-policy h4, h5 {
              color: #c6cbff;
              line-height: 2.6;
            }
          .privacy-policy h4 {
              font-size: 1.6em;
            }
          .privacy-policy h5 {
              font-size: 1.2em;
             margin-top: 1em; 
            }
          .privacy-policy ul {
              list-style-type: circle;
              margin-left: 1.6em;
              display: block;
            }
          .privacy-policy .boldtxt {
             font-weight: 900;   
            }
        </style>
    @elseif ($page->slug === 'terms-conditions')
        <style>
          .terms-conditions h4, h5 {
              color: #c6cbff;
              line-height: 2.6;
            }
          .terms-conditions h4 {
              font-size: 1.6em;
            }
          .terms-conditions h5 {
              font-size: 1.2em;
             margin-top: 1em; 
            }
          .terms-conditions ul {
              list-style-type: circle;
              margin-left: 1.6em;
              display: block;
            }
          .terms-conditions .boldtxt {
             font-weight: 900;   
            }
        </style>
    @elseif  ($page->slug === 'risk-disclosure')
        <style>
          .risk-disclosure h4, h5 {
              color: #c6cbff;
              line-height: 2.6;
            }
          .risk-disclosure h4 {
              font-size: 1.6em;
            }
          .risk-disclosure h5 {
              font-size: 1.2em;
             margin-top: 1em; 
            }
          .risk-disclosure ul {
              list-style-type: circle;
              margin-left: 1.6em;
              display: block;
            }
          .privacy-policy .boldtxt {
             font-weight: 900;   
            }
        </style>		
    @endif
    
@endpush

@section('content')
	<!-- Banner -->
	<section class="banner-section bg--gradient overflow-hidden position-relative border-bottom">
		<div class="hero-bg bg_img" data-img="{{ asset('assets/images/'.$gs->breadcumb_banner) }}"></div>
		<div class="container">
			<div class="hero-text">
				<h2 class="hero-text-title">{{ $page->title }}</h2>
				<ul class="breadcrumb">
					<li>
						<a href="{{route('front.index')}}">@lang('Home')</a>
					</li>
					<li>
						@lang('Pages')
					</li>
				</ul>
			</div>
		</div>
		</div>
	</section>
	<!-- Banner -->


	<!-- About -->
	<section class="about-section pt-100 pb-50 {{ $page->slug }}">
		<div class="container">
			<div class="row gy-5">
				<div class="col-lg-12">
					<div class="about-content">
						<div class="section-title">
							<p>
								@php
									echo $page->details;
								@endphp
							</p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- About -->

	

@endsection

@push('js')
    
@endpush