<?php

namespace App\Http\Controllers\Deposit;

use App\Classes\GeniusMailer;
use App\Http\Controllers\Controller;
use App\Models\Currency;
use App\Models\Deposit;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use App\Models\Generalsetting;

class ManualController extends Controller
{
    public function store(Request $request){

        $currency = Currency::where('id',$request->currency_id)->first();
        $amountToAdd = $request->amount/$currency->value;

        $deposit = new Deposit();
        $deposit['deposit_number'] = Str::random(12);
        $deposit['user_id'] = auth()->id();
        $deposit['currency_id'] = $request->currency_id;
        $deposit['amount'] = $amountToAdd;
        $deposit['method'] = $request->method;
        $deposit['txnid'] = $request->txn_id4;
        $deposit['status'] = "pending";
        $deposit->save();


        $gs =  Generalsetting::findOrFail(1);
        $user = auth()->user();

        $to = $user->email;
        $subject = 'Deposit Form Received – Pending Confirmation';
        //$msg = "Dear Customer,<br> Your deposit in process.";
        $msg = '<!DOCTYPE html>
                <html lang="en">
                <head>
                    <meta charset="UTF-8">
                    <meta name="viewport" content="width=device-width, initial-scale=1.0">
                    <title>Deposit Form Received – Pending Confirmation</title>
                    <style>
                        body {
                            margin: 0;
                            padding: 0;
                            font-family: "Arial", sans-serif;
                            background-color: #f7f7f7;
                        }
                        .email-wrapper {
                            width: 100%;
                            background-color: #f7f7f7;
                            padding: 20px 0;
                        }
                        .email-content {
                            width: 100%;
                            max-width: 600px;
                            background-color: #ffffff;
                            border-radius: 8px;
                            margin: 0 auto;
                            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
                        }
                        .email-header {
                            background-color: #003366;
                            padding: 20px;
                            text-align: center;
                            border-radius: 8px 8px 0 0;
                        }
                        .email-header img {
                            max-width: 200px;
                        }
                        .email-header span {
                            font-size: 18px;
                            font-weight: 600;
                            color: #00BFFF;
                            display: block;
                            margin-top: 10px;
                        }
                        .email-body {
                            padding: 16px 30px;
                            font-size: 16px;
                            line-height: 1.5;
                            color: #333;
                        }
                        .email-body h3 {
                            color: #003366;
                            margin-bottom: 15px;
                        }
                        .email-body p {
                            margin-bottom: 20px;
                        }
                        .email-button {
                            display: inline-block;
                            background-color: #003366;
                            color: #ffffff !important;
                            padding: 6px 12px;
                            font-size: 16px;
                            border-radius: 5px;
                            text-decoration: none;
                        }
                        .email-footer {
                            background-color: #1f1f1f;
                            color: #ffffff;
                            text-align: center;
                            padding: 12px;
                            border-radius: 0 0 8px 8px;
                            font-size: 14px;
                        }
                        .email-footer a {
                            color: #00BFFF;
                            text-decoration: none;
                        }
                    </style>
                </head>
                <body>
                
                <div class="email-wrapper">
                    <div class="email-content">
                        <div class="email-header">
                            <img src="https://fluxeassets.com/imgx/etemp.png" alt="Fluxe Assets Logo">
                            <span>Guiding You Toward Financial Growth</span>
                        </div>
                        <div class="email-body">
                            <p>Dear <strong>'.$user->name.'</strong>,</p>
                            <p>Thank you for submitting your deposit form to <strong>Fluxe Assets</strong>.</p>
                			<p>We have received your form and are currently awaiting confirmation of the actual deposit. Once verified, the funds will be held in your Fluxe Assets account until you select an investment PLAN.</p>
                			<p>If you have already made the deposit, please allow some time for processing. For any questions or assistance, feel free to <a href="https://fluxeassets.com/contact" style="color: #0073e6; text-decoration: none;" target="_blank">contact us</a>.</p>
                			<p style="margin-top: 30px;">Best regards,<br>The Fluxe Assets Team</p>
                			
                        </div>
                        <div class="email-footer">
                            <p>Copyright &copy; 2025 <a href="https://fluxeassets.com">Fluxe Assets</a>. All rights reserved.</p>
                        </div>
                    </div>
                </div>
                
                </body>
                </html>';

        if($gs->is_smtp == 1)
        {
            /*
            $data = [
                'to' => $user->email,
                'type' => "Deposit",
                'cname' => $user->name,
                'oamount' => $deposit->amount,
                'aname' => "",
                'aemail' => "",
                'wtitle' => "",
            ];

            $mailer = new GeniusMailer();
            $mailer->sendAutoMail($data);
            */

            $mail = new PHPMailer(true);
    
            try {
                // SMTP settings
                $mail->isSMTP();
                $mail->Host       = $gs->smtp_host;
                $mail->SMTPAuth   = true;
                $mail->Username   = $gs->smtp_user;
                $mail->Password   = $gs->smtp_pass;
                $mail->SMTPSecure = $gs->smtp_encryption; // 'tls' or 'ssl'
                $mail->Port       = $gs->smtp_port;
				$mail->CharSet = 'UTF-8';
    
                // Recipients
                $mail->setFrom($gs->from_email, $gs->from_name);
                $mail->addAddress($user->email, $user->name);
    
                // Content
                $mail->isHTML(true);
                $mail->Subject = $subject;
                $mail->Body    = $msg;
				
				$mail->send();
				
			} catch (Exception $e) {
			return response()->json('Email could not be sent. Error: ' . $mail->ErrorInfo);
			}
            
        }
        else
        {
            $headers = "From: ".$gs->from_name."<".$gs->from_email.">";
            mail($to,$subject,$msg,$headers);
        }

        return redirect()->route('user.deposit.create')->with('success','Deposit amount '.$request->amount.' ('.$request->currency_code.') successfully!');
    }
}
