<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<title><?php echo e($gs->title); ?></title>
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/animate.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/all.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/lightbox.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/odometer.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/owl.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/main.css')); ?>" />
	<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/toastr.min.css')); ?>">

    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/'.$gs->favicon)); ?>">

</head>

<body>
    <!-- Overlayer -->
    <span class="toTopBtn">
        <i class="fas fa-angle-up"></i>
    </span>
    <div class="overlayer"></div>
    <div class="loader"></div>
    <!-- Overlayer -->

    <!-- User Dashboard -->
    <main class="dashboard-section">
		<?php echo $__env->make('includes.user.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <article class="main--content">
			<?php echo $__env->make('includes.user.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="dashborad--content">
				<?php echo $__env->yieldContent('contents'); ?>
				<?php echo $__env->make('includes.user.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </article>
    </main>
    <!-- User Dashboard -->

	<script>
		let mainurl = '<?php echo e(url('/')); ?>';
	</script>
    <script src="<?php echo e(asset('assets/front/js/jquery-3.6.0.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/viewport.jquery.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/odometer.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/lightbox.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/owl.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/front/js/notify.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/main.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/front/js/toastr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/custom.js')); ?>"></script>


	<script>
		'use strict';
        var mercadogateway = null;

		<?php if(Session::has('message')): ?>
		toastr.options =
		{
			"closeButton" : true,
			"progressBar" : true
		}
			toastr.success("<?php echo e(session('message')); ?>");
		<?php endif; ?>

		<?php if(Session::has('error')): ?>
		toastr.options =
		{
			"closeButton" : true,
			"progressBar" : true
		}
			toastr.error("<?php echo e(session('error')); ?>");
		<?php endif; ?>

		<?php if(Session::has('info')): ?>
		toastr.options =
		{
			"closeButton" : true,
			"progressBar" : true
		}
			toastr.info("<?php echo e(session('info')); ?>");
		<?php endif; ?>

		<?php if(Session::has('warning')): ?>
		toastr.options =
		{
			"closeButton" : true,
			"progressBar" : true
		}
			toastr.warning("<?php echo e(session('warning')); ?>");
		<?php endif; ?>
	</script>

    <?php echo $__env->yieldPushContent('js'); ?>
</body>

</html>


<?php /**PATH /home/fluxyjvi/public_html/project/resources/views/layouts/user.blade.php ENDPATH**/ ?>