<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('contents'); ?>
<div class="breadcrumb-area">
    <h3 class="title"><?php echo app('translator')->get('Deposit History'); ?></h3>
    <ul class="breadcrumb">
        <li>
            <a href="<?php echo e(route('user.deposit.index')); ?>"><?php echo app('translator')->get('Deposit'); ?></a>
        </li>
        <li>
            <?php echo app('translator')->get('Deposit History'); ?>
        </li>
    </ul>
</div>

<div class="dashboard--content-item">
  <div class="card p-3 default--card">
    <form action="<?php echo e(route('user.deposit.index')); ?>" method="get">
      <div class="row g-3">
        <div class="col-md-4">
          <input name="trx_no" class="form-control" autocomplete="off" placeholder="<?php echo e(__('Deposit number')); ?>" type="text" value="<?php echo e(old('trx_no')); ?>">
        </div>

        <div class="col-md-4">
          <select id="type" name="type" required class="form-control">
            <option value=""><?php echo e(__('Select Method')); ?></option>
            <option value="all"><?php echo e(__('All')); ?></option>
            <option value="stripe"><?php echo e(__('Stripe')); ?></option>
            <option value="paypal"><?php echo e(__('Paypal')); ?></option>
            <option value="authorize.net"><?php echo e(__('Authorize.net')); ?></option>
            <option value="flutterwave"><?php echo e(__('Flutterwave')); ?></option>
            <option value="mollie"><?php echo e(__('Mollie Payment')); ?></option>
            <option value="instamojo"><?php echo e(__('Instamojo')); ?></option>
            <option value="razorpay"><?php echo e(__('Razorpay')); ?></option>
            <option value="paytm"><?php echo e(__('Paytm')); ?></option>
          </select>
        </div>

        <div class="col-md-4">
          <button type="submit" class="cmn--btn bg--primary submit-btn w-100 border-0"><?php echo e(__('Submit')); ?></button>
        </div>
      </div>
    </form>
  </div>
</div>

<div class="dashboard--content-item">
    <div class="table-responsive table--mobile-lg">
        <table class="table bg--body">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Deposit Date'); ?></th>
                    <th><?php echo app('translator')->get('Deposit Number'); ?></th>
                    <th><?php echo app('translator')->get('Method'); ?></th>
                    <th><?php echo app('translator')->get('Account'); ?></th>
                    <th><?php echo app('translator')->get('Amount'); ?></th>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                </tr>
            </thead>
            <tbody>
              <?php if(count($deposits) == 0): ?>
              <tr>
                <td colspan="12">
                  <h4 class="text-center m-0 py-2"><?php echo e(__('No Data Found')); ?></h4>
                </td>
              </tr>
              <?php else: ?>
                <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                      <td data-label="Deposit Date">
                        <div>
                            <?php echo e(date('d-M-Y',strtotime($data->created_at))); ?>

                        </div>
                      </td>

                      <td data-label="Deposit Number">
                        <div>
                            <?php echo e(strtoupper($data->deposit_number)); ?>

                        </div>
                      </td>

                      <td data-label="Method">
                        <div>
                            <?php echo e(ucfirst($data->method)); ?>

                        </div>
                      </td>

                      <td data-label="Account">
                        <div>
                            <?php echo e(auth()->user()->email); ?>

                        </div>
                      </td>

                      <td data-label="Amount">
                          <div>
                            <?php echo e(showprice($data->amount,$currency)); ?>

                          </div>
                      </td>


                        <td data-label="Status">
                            <div>
                                <?php if($data->status == 'pending'): ?>
                                    <span class="badge btn--warning btn-sm"><?php echo app('translator')->get('Pending'); ?></span>
                                <?php elseif($data->status == 'reject'): ?>
                                    <span class="badge btn--danger btn-sm"><?php echo app('translator')->get('Rejected'); ?></span>
                                <?php else: ?>
                                    <span class="badge btn--success btn-sm"><?php echo app('translator')->get('Completed'); ?></span>
                                <?php endif; ?>
                            </div>
                        </td>

                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php endif; ?>
            </tbody>
        </table>
    </div>
    <?php echo e($deposits->links()); ?>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fluxyjvi/public_html/project/resources/views/user/deposit/index.blade.php ENDPATH**/ ?>