@extends('layouts.front')

@push('css')

@endpush

@section('content')

    @if (in_array('Banner', $home_modules))
        <!-- Banner -->
        <section class="banner-section bg--gradient overflow-hidden">
            <div class="particle"></div>
            <div class="particle2"></div>
            <div class="particle3"></div>
            <div class="particle4"></div>
            <div class="banner-bg bg_img" data-img="{{ asset('assets/images/'.$ps->hero_photo) }}">
                <div class="container">
                    <div class="banner-wrapper">
                        <div class="banner-cont text--light">
                            <h1 class="title text--base">{{ $ps->hero_title }}</h1>
                            <p>
                                {{ $ps->hero_subtitle }}
                            </p>
                            <div class="btn__grp">
                                <a href="{{ $ps->hero_btn_url }}" class="cmn--btn">@lang('Start Investing Today') <span class="round-effect">
                                        <i class="fas fa-long-arrow-alt-right"></i>
                                    </span></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Banner -->
    @endif

    @if (in_array('About', $home_modules))
        <!-- About -->
        <section class="about-section overflow-hidden pt-100 pb-100 position-relative">
            <div class="container">
                <div class="row gy-4 gy-sm-5 flex-wrap-reverse align-items-center">
                    <div class="col-lg-6">
                        <div class="about--img">
                            <img src="{{ asset('assets/images/'.$ps->about_photo) }}" alt="about us">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="about--content">
                            <div class="section-header mb-4">
                                <h6 class="section-header__subtitle">@lang('Who We are')</h6>
                                <h3 class="section-header__title">{{ $ps->about_title }}</h3>

                            </div>
                            <p class="about-txt m-0 mb-4">
                                @php
                                    echo $ps->about_text;
                                @endphp
                            </p>
                            <a href="{{ $ps->about_link }}" class="cmn--btn">@lang('Read More')
                                <span class="round-effect">
                                    <i class="fas fa-long-arrow-alt-right"></i>
                                </span>
                            </a>
                        </div>
                        <div class="border-top mt-4">
                            <div class="counter-area">
                                @foreach ($counters as $key=>$data)
                                    <div class="counter-item">
                                        <div class="counter-thumb">
                                            <img src="{{asset('assets/images/'.$data->photo)}}" alt="about">
                                        </div>
                                        <div class="counter-content">
                                            <div class="counter-header">
                                                <h4 class="title odometer" data-odometer-final="{{ $data->count }}">0</h4>
                                                <h4 class="title">{{ $data->messurement }}</h4>
                                            </div>
                                            <h6 class="text--base">{{ $data->title }}</h6>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- / About -->
    @endif

    @if (in_array('Profit Calculator', $home_modules))
        <!-- Profit Calculator -->
        <section class="profit-calculator pt-100 pb-100 bg--shapes overflow-hidden">
            <div class="container position-relative">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <div class="profit-thumb">
                            <img src="{{ asset('assets/images/'.$ps->profit_banner) }}" alt="profit">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="profit-calculator-area">
                            <div class="section-header text-lg-start">
                                <h6 class="section-header__subtitle">@lang('Profit Calculator')</h6>
                                <h3 class="section-header__title">{{ $ps->profit_title }}</h3>
                                <p>
                                @php
                                    echo $ps->profit_text;
                                @endphp
                                </p>
                            </div>
                            <form id="profitCalculate" class="row gy-4" action="{{ route('front.profit.calculate') }}" method="POST">
                                @includeIf('includes.user.form-both')
                                @csrf
                                <div class="col-md-6">
                                    <label for="select-plan" class="form-label">@lang('Select Plan')</label>
                                    <select name="plan" id="select-plan" class="form-control form--control bg--section">
                                        @foreach ($plans as $key=>$data)
                                            <option value="{{ $data->id }}">{{ $data->title }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label for="amount" class="form-label">@lang('Enter Amount')</label>
                                    <input type="number" name="amount" class="form-control form--control bg--section" placeholder="0.00">
                                </div>
                                <div class="col-md-12">
                                    <label for="profit-amount" class="form-label">@lang('Profit Amount')</label>
                                    <input type="text" class="form-control form--control bg--section profitCalBoxAmount" id="profit-calculate-amount"
                                        value="0.00" readonly>
                                </div>
                                <div class="col-md-12">
                                    <button class="cmn--btn" type="submit">@lang('Calculate Now')</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- / Profit Calculator -->
    @endif


    @if (in_array('Investment Plan', $home_modules))
        <!-- Investment Plan -->
        <section class="investment-plan-section overflow-hidden bg--gradient-light pb-50 pt-80 border-top">
            <div class="container">
                <div class="section-header text-center">
                    <h6 class="section-header__subtitle">@lang('Investment Plans & Pricing')</h6>
                    <h3 class="section-header__title">{{ $ps->plan_title }}</h3>
                    <p>
                        {{ 'Choose from flexible investment packages designed to match your financial goals — whether you are starting small or scaling big.' }}
                    </p>
                </div>
                <div class="pricing--wrapper row g-3 g-md-4 g-lg-3 g-xxl-4 justify-content-center">
                    @foreach ($plans->take(4) as $key=>$data)
                    @php
                        $schedule = \App\Models\ManageSchedule::where('time',$data->schedule_hour)->first();
                    @endphp
                        <div class="col-lg-3 col-sm-6 col-md-6">
                            <div class="plan__item">
                                <div class="plan__item-header">
                                    <div class="left">
                                        <h5 class="title">{{ $data->title }}</h5>
                                        <span>{{ $data->subtitle }}</span>
                                    </div>
                                    <div class="right">
                                        <h5 class="title">{{ $data->profit_percentage }}%</h5>
                                        <span>@lang('Return')</span>
                                    </div>
                                </div>
                                <div class="plan__item-body">
                                    <ul>
                                        <li>
                                            <span class="name">@lang('Profit')</span>
                                            <span class="info">
                                                {{ $data->lifetime_return == 1 ? 'Lifetime' :  'Every '.$schedule->name }}
                                            </span>
                                        </li>

                                        <li>
                                            <span class="name me-1">@lang('Capital will back')</span>
                                            <span class="badge align-self-center me-auto bg--{{ $data->captial_return == 1 ? 'primary' : 'danger'}}">{{ $data->captial_return == 1 ? 'Yes' : 'No'}}</span>
                                        </li>

                                        <li>
                                            <span class="name {{ $data->profit_repeat == NULL ?? me-1 }}">@lang('Repeatable')</span>
                                            @if ($data->profit_repeat == NULL)
                                                <span class="badge align-self-center me-auto bg--danger">@lang('NO')</span>
                                            @else
                                                <span class="info">
                                                    {{ $data->profit_repeat.' Times' }}
                                                </span>
                                            @endif
                                        </li>
                                    </ul>

                                    @if ($data->invest_type == 'range')
                                        <h6 class="text-center amount-range">{{ showPrice($data->min_amount) }} - {{ showPrice($data->max_amount) }}</h6>
                                    @else
                                        <h6 class="text-center amount-range">{{ showPrice($data->fixed_amount) }}</h6>
                                    @endif
                                    
                                    @if(auth()->user())
                                    <button class="cmn--btn w-100 invest-plan" type="button" data-bs-toggle="modal"
                                        data-bs-target="#invest-modal" data-title="{{ $data->title }}" data-id="{{ $data->id }}" data-type="{{ $data->invest_type == 'range' ? 0 : 1}}" data-fixAmount="{{ rootPrice($data->fixed_amount) }}">
                                        @lang('Invest Now')
                                    </button>
                                    @else
                                    <a class="cmn--btn w-100 invest-plan" href="{{ route('user.login') }}" >
                                        @lang('Invest Now')
                                    </a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="text-center mt-5">
                    <a href="{{ route('front.plans') }}" class="cmn--btn btn-outline">@lang('All Packages')</a>
                </div>
            </div>
        </section>
        <!-- / Investment Plan -->
    @endif


    @if (in_array('How To Start', $home_modules))
        <!-- How To Start -->
        <section class="how-to-start-section pt-80 pb-50 border-top border-bottom overflow-hidden">
            <div class="container">
                <div class="row align-items-center flex-wrap-reverse gy-5">
                    <div class="col-lg-6">
                        <div class="pe-xl-4 pe-xxl-5">
                            <div class="section-header text-lg-end">
                                <h6 class="section-header__subtitle">@lang('How To Get Started')</h6>
                                <h3 class="section-header__title">{{ $ps->start_title }}</h3>
                                <p>
                                    @php
                                        echo $ps->start_text;
                                    @endphp
                                </p>
                            </div>
                            <div class="how-wrapper">
                                @foreach ($process as $key=>$data)
                                    <div class="how__item">
                                        <div class="how__item-thumb">
                                            <i class="{{$data->icon}}"></i>
                                        </div>
                                        <div class="how__item-content">
                                            <h5 class="how__item-title text--base">
                                                {{ $data->title}}
                                            </h5>
                                            <p>
                                            @php
                                                echo $data->details;
                                            @endphp
                                            </p>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="how-thumb">
                            <img src="{{asset('assets/images/'.$ps->start_photo)}}" alt="about" />
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- How To Start -->
    @endif


    @if (in_array('Choose', $home_modules))
        <!-- Choose -->
        @includeIf('partials.front.choose')
        <!-- Choose -->
    @endif

<!-- Referral --
    @if (in_array('Referral', $home_modules))
        <section class="referral-section pt-50 pb-100">
            <div class="container">
                <div class="row align-items-center justify-content-between flex-wrap-reverse">
                    <div class="col-lg-6 col-xl-5">
                        <div class="referral-thumb">
                            <img src="{{ asset('assets/images/'.$ps->referral_banner) }}" alt="about">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="section-header mb-lg-0">
                            <h6 class="section-header__subtitle">@lang('Referral Comission')</h6>
                            <h2 class="section-header__title">{{ $ps->referral_title }}</h2>
                            <p>
                                @php
                                    echo $ps->referral_text;
                                @endphp
                            </p>
                            <div class="comission-area">
                                @if ($ps->referral_percentage)
                                    @foreach (json_decode($ps->referral_percentage,true) as $key=>$data)
                                        <div class="comission-item">
                                            <div class="thumb">
                                                {{$data}}%
                                            </div>
                                            <div class="cont">
                                                <div class="name">@lang('Level 0') {{ $key + 1}}</div>
                                            </div>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                            <a href="#" class="cmn--btn">
                                @lang('Send Referral Link') <span class="round-effect"><i
                                        class="fas fa-long-arrow-alt-right"></i></span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
-- Referral -->


    @if (in_array('Testimonials', $home_modules))
        <!-- Testimonials -->
        <section class="testimonial-section pt-100 pb-50 border-top">
            <div class="container">
                <div class="client__slider owl-theme owl-carousel">
                    @foreach ($testimonials as $key=>$data)
                        <div class="client__item">
                            <div class="client__item-img">
                                <img src="{{ asset('assets/images/'.$data->photo) }}" alt="clients">
                            </div>
                            <div class="client__item-cont bg--section">
                                <div class="section-header">
                                    <h6 class="section-header__subtitle">{{ $data->title }}</h6>
                                    <h5 class="section-header__title" style="font-weight: 100 !important;">{{ $data->subtitle }}</h5>
                                </div>
                                <blockquote class="quote">
                                    @php
                                        echo $data->details;
                                    @endphp
                                </blockquote>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
        <!-- Testimonials -->
    @endif
    
    <section>
        <div style="background-color: #1D2330; border: 1px solid #282E3B; border-radius: 4px; width: 100%; padding: 5px;">
        <!--<h3 style="color: #ffffff; font-family: sans-serif; font-size: 14px; margin-bottom: 5px;">Live Market Trends</h3>-->
        <iframe src="https://widget.coinlib.io/widget?type=horizontal_v2&theme=dark&pref_coin_id=1505&invert_hover=no" width="100%" height="36px" scrolling="auto" frameborder="0" style="border:0;"></iframe>
        </div>
    </section>


@endsection

@push('js')

@endpush
