<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <?php if(isset($page->meta_tag) && isset($page->meta_description)): ?>
        <meta name="keywords" content="<?php echo e($page->meta_tag); ?>">
        <meta name="description" content="<?php echo e($page->meta_description); ?>">
    <?php elseif(isset($blog->meta_tag) && isset($blog->meta_description)): ?>
        <meta name="keywords" content="<?php echo e($blog->meta_tag); ?>">
        <meta name="description" content="<?php echo e($blog->meta_description); ?>">
    <?php else: ?>
        <meta name="keywords" content="<?php echo e($seo->meta_keys); ?>">
        <meta name="author" content="Fluxe Assets">
    <?php endif; ?>
    <title><?php echo e($gs->title); ?></title>

    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/animate.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/all.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/lightbox.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/odometer.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/owl.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/main.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/toastr.min.css')); ?>">


    <?php if($default_font->font_value): ?>
        <link href="https://fonts.googleapis.com/css?family=<?php echo e($default_font->font_value); ?>&display=swap" rel="stylesheet">
    <?php else: ?>
        <link href="https://fonts.googleapis.com/css?family=Open+Sans&display=swap" rel="stylesheet">
    <?php endif; ?>

    <?php if($default_font->font_family): ?>
        <link rel="stylesheet" id="colorr" href="<?php echo e(asset('assets/front/css/font.php?font_familly='.$default_font->font_family)); ?>">
    <?php else: ?>
        <link rel="stylesheet" id="colorr" href="<?php echo e(asset('assets/front/css/font.php?font_familly='."Open Sans")); ?>">
    <?php endif; ?>

    <?php echo $__env->yieldPushContent('css'); ?>
    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/'.$gs->favicon)); ?>">
</head>

<body>
    <!-- Overlayer -->
    <span class="toTopBtn">
        <i class="fas fa-angle-up"></i>
    </span>
    <div class="overlayer"></div>
    <div class="loader"></div>
    <div class="particle"></div>
    <div class="particle2"></div>
    <div class="particle3"></div>
    <div class="particle4"></div>
    <!-- Overlayer -->


    <!-- Account Section -->
    <section class="accounts-section">
        <div class="accounts-inner">
            <div class="accounts-inner__wrapper bg--section">
                <div class="accounts-left">
                    <div class="accounts-left-content">
                        <a href="<?php echo e(url('/')); ?>">
                            <img src="<?php echo e(asset('assets/images/'.$gs->logo)); ?>" alt="logo" />
                        </a>
                        <div class="section-header">
                            <!--<h6 class="section-header__subtitle"></h6>-->
                            <p><h4 class="section-header__title"><?php echo app('translator')->get('Forgot Password'); ?></h4></p>
                        </div>
                <form class="account-form row gy-3 gx-4 align-items-center" id="forgotform" action="<?php echo e(route('user.forgot.submit')); ?>" method="POST">
                    <?php if ($__env->exists('includes.user.form-both')) echo $__env->make('includes.user.form-both', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo csrf_field(); ?>
                    <div class="col-sm-12">
                        <label for="email" class="form-label"><?php echo app('translator')->get('Your Email'); ?></label>
                        <input type="text" id="email" name="email" class="form-control form--control">
                    </div>

                    <div class="col-sm-12">
                        <button type="submit" class="cmn--btn bg--base me-3">
                            <?php echo app('translator')->get('Submit'); ?> <div class="spinner-border formSpin" role="status"></div>
                        </button>
                        <div class="d-flex flex-wrap justify-content-between align-items-center mt-2">
                            <a href="<?php echo e(route('user.login')); ?>" class="text--base mt-1"><?php echo app('translator')->get('Login Now?'); ?></a>
                        </div>
                    </div>
                </form>
                    </div>
                </div>
                <div class="accounts-right bg--blue">
                    <!--<img src="<?php echo e(asset('assets/images/logreg.png')); ?>" alt="images">-->
                    <div class="section-header text-center text-white mb-0">
                        <!--<h6 class="section-header__subtitle"></h6>-->
                        <h3 class="section-header__title"><?php echo e($ps->login_title); ?></h3>
                        <p>
                            <?php
                                echo $ps->login_subtitle;
                            ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Accounts Section -->


    <script src="<?php echo e(asset('assets/front/js/jquery-3.6.0.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/viewport.jquery.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/odometer.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/lightbox.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/owl.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/toastr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/notify.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/main.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/custom.js')); ?>"></script>

</body>

</html><?php /**PATH /home/fluxyjvi/public_html/project/resources/views/user/forgot.blade.php ENDPATH**/ ?>