<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('contents'); ?>
<div class="breadcrumb-area">
  <h3 class="title"><?php echo app('translator')->get('Transfer Money'); ?></h3>
  <ul class="breadcrumb">
      <li>
        <a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
      </li>

      <li>
          <?php echo app('translator')->get('Transfer Money'); ?>
      </li>
  </ul>
</div>

<div class="dashboard--content-item">
  <div class="row g-3">
    <div class="col-12">
      <div class="card default--card">
        <div class="card-body">
            <?php if ($__env->exists('includes.flash')) echo $__env->make('includes.flash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <form id="request-form" action="<?php echo e(route('money.transfer.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <div class="row gy-3 gy-md-4">
                  <div class="col-sm-6">
                    <div class="form-group">
                      <label class="form-label required"><?php echo e(__('Receiver Email')); ?></label>
                      <input name="email" id="accountemail" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" autocomplete="off" placeholder="<?php echo e(__('doe@gmail.com')); ?>" type="email" value="<?php echo e(old('email')); ?>">
                      <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-danger mt-2"><?php echo e($message); ?></p>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    </div>
                  </div>

                  <div class="col-sm-6">
                    <div class="form-group">
                      <label class="form-label required"><?php echo e(__('Account Name')); ?></label>
                      <input name="name" id="account_name" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" autocomplete="off" placeholder="<?php echo e(__('John Doe')); ?>" type="text" value="<?php echo e(old('name')); ?>">
                      <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-danger mt-2"><?php echo e($message); ?></p>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                  </div>

                  <div class="col-sm-6">
                    <div class="form-group">
                      <label class="form-label required"><?php echo e(__('Amount')); ?></label>
                      <input name="amount" id="amount" class="form-control <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" autocomplete="off" placeholder="<?php echo e(__('0.0')); ?>" type="number" value="<?php echo e(old('amount')); ?>" min="1">
                      <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-danger mt-2"><?php echo e($message); ?></p>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                  </div>

                  <div class="col-sm-6">
                    <label class="form-label required"><?php echo e(__('Wallet')); ?></label>
                    <select name="wallet" id="wallet" class="form-control <?php $__errorArgs = ['wallet'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <option value=""><?php echo e(__('Select Wallet')); ?></option>
                        <option value="main_balance"><?php echo e(__('Main Balance')); ?></option>
                        <option value="interest_balance"><?php echo e(__('Interest Balance')); ?></option>
                    </select>
                    <?php $__errorArgs = ['wallet'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                      <p class="text-danger mt-2"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  </div>

                  <div class="col-sm-6">
                    <label class="form-label required"><?php echo e(__('Password')); ?></label>
                      <input name="password" id="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" autocomplete="off"  type="password">
                      <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-danger mt-2"><?php echo e($message); ?></p>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  </div>

                  <div class="col-sm-6">
                    <label class="form-label d-none d-sm-block">&nbsp;</label>
                    <button type="submit" class="cmn--btn bg--primary submit-btn w-100 border-0"><?php echo e(__('Submit')); ?></button>

                  </div>
                </div>

            </form>
        </div>
      </div>
  </div>
  </div>
</div>

<div class="dashboard--content-item">
    <div class="table-responsive table--mobile-lg">
        <table class="table bg--body">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Date'); ?></th>
                    <th><?php echo app('translator')->get('Transaction'); ?></th>
                    <th><?php echo app('translator')->get('Receiver'); ?></th>
                    <th><?php echo app('translator')->get('Amount'); ?></th>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                </tr>
            </thead>
            <tbody>
              <?php if(count($transfers) == 0): ?>
                <tr>
                  <td colspan="12">
                    <h4 class="text-center m-0 py-2"><?php echo e(__('No Data Found')); ?></h4>
                  </td>
                </tr>
              <?php else: ?>
                <?php $__currentLoopData = $transfers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <?php
                      $receiver = \App\Models\User::whereId($data->receiver_id)->first();
                  ?>
                    <tr>
                        <td data-label="Date">
                            <div>
                                <?php echo e($data->created_at->toFormattedDateString()); ?>

                            </div>
                        </td>

                        <td data-label="Transaction">
                            <div>
                              <?php echo e(strtoupper($data->transaction_no)); ?>

                            </div>
                        </td>

                        <td data-label="Receiver">
                            <div>
                                <?php echo e($receiver != NULL ? $receiver->email : 'Customer Deleted'); ?>

                            </div>
                        </td>

                        <td data-label="Amount">
                            <div>
                              <?php echo e(showNameAmount($data->amount)); ?>

                            </div>
                        </td>

                        <td data-label="Status">
                            <div>
                              <span class="badge btn--<?php echo e($data->status == 1 ? 'success' : 'warning'); ?> btn-sm"><?php echo e($data->status == 1 ? 'Succeed' : 'Pending'); ?></span>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php endif; ?>

            </tbody>
        </table>
    </div>
    <?php echo e($transfers->links()); ?>

</div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script>
  'use strict';

  $("#account_name").on('click',function(){
    let accountEmail = $("#accountemail").val();

    let url = `${mainurl}/user/username/${accountEmail}`;

    $.get(url, function(data){
      $("#account_name").val(data);
    });
  })
</script>
<?php $__env->stopPush(); ?>




<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fluxyjvi/public_html/project/resources/views/user/transfer/index.blade.php ENDPATH**/ ?>