rn count(array_filter($this->suiteTests, function (TestResult $testResult) use ($type) {
            return $testResult->type === $type;
        }));
    }

    /**
     * Returns the printable test case name from the given `TestCase`.
     */
    public static function getPrintableTestCaseName(TestMethod $test): string
    {
        $className = explode('::', $test->id())[0];

        if (is_subclass_of($className, HasPrintableTestCaseName::class)) {
            return $className::getPrintableTestCaseName();
        }

        return $className;
    }
}
PK     Xs[a^>  >  +  Adapters/Phpunit/Subscribers/Subscriber.phpnu [        <?php

declare(strict_types=1);

/**
 * This file is part of Collision.
 *
 * (c) Nuno Maduro <enunomaduro@gmail.com>
 *
 *  For the full copyright and license information, please view the LICENSE
 *  file that was distributed with this source code.
 */

namespace NunoMaduro\Collision\Adapters\Phpunit\Subscribers;

use NunoMaduro\Collision\Adapters\Phpunit\Printers\ReportablePrinter;

/**
 * @internal
 */
abstract class Subscriber
{
    /**
     * The printer instance.
     */
    private ReportablePrinter $printer;

    /**
     * Creates a new subscriber.
     */
    public function __construct(ReportablePrinter $printer)
    {
        $this->printer = $printer;
    }

    /**
     * Returns the printer instance.
     */
    protected function printer(): ReportablePrinter
    {
        return $this->printer;
    }
}
PK     Xs[nEr/  /  D  Adapters/Phpunit/Subscribers/EnsurePrinterIsRegisteredSubscriber.phpnu [        <?php

declare(strict_types=1);

namespace NunoMaduro\Collision\Adapters\Phpunit\Subscribers;

use NunoMaduro\Collision\Adapters\Phpunit\Printers\DefaultPrinter;
use NunoMaduro\Collision\Adapters\Phpunit\Printers\ReportablePrinter;
use PHPUnit\Event\Application\Started;
use PHPUnit\Event\Application\StartedSubscriber;
use PHPUnit\Event\Facade;
use PHPUnit\Event\Test\BeforeFirstTestMethodErrored;
use PHPUnit\Event\Test\BeforeFirstTestMethodErroredSubscriber;
use PHPUnit\Event\Test\ConsideredRisky;
use PHPUnit\Event\Test\ConsideredRiskySubscriber;
use PHPUnit\Event\Test\DeprecationTriggered;
use PHPUnit\Event\Test\DeprecationTriggeredSubscriber;
use PHPUnit\Event\Test\Errored;
use PHPUnit\Event\Test\ErroredSubscriber;
use PHPUnit\Event\Test\Failed;
use PHPUnit\Event\Test\FailedSubscriber;
use PHPUnit\Event\Test\Finished;
use PHPUnit\Event\Test\FinishedSubscriber;
use PHPUnit\Event\Test\MarkedIncomplete;
use PHPUnit\Event\Test\MarkedIncompleteSubscriber;
use PHPUnit\Event\Test\NoticeTriggered;
use PHPUnit\Event\Test\NoticeTriggeredSubscriber;
use PHPUnit\Event\Test\Passed;
use PHPUnit\Event\Test\PassedSubscriber;
use PHPUnit\Event\Test\PhpDeprecationTriggered;
use PHPUnit\Event\Test\PhpDeprecationTriggeredSubscriber;
use PHPUnit\Event\Test\PhpNoticeTriggered;
use PHPUnit\Event\Test\PhpNoticeTriggeredSubscriber;
use PHPUnit\Event\Test\PhpunitDeprecationTriggered;
use PHPUnit\Event\Test\PhpunitDeprecationTriggeredSubscriber;
use PHPUnit\Event\Test\PhpunitErrorfacade.
         */
        private static bool $registered = false;

        /**
         * Runs the subscriber.
         */
        public function notify(Started $event): void
        {
            $printer = new ReportablePrinter(new DefaultPrinter(true));

            if (isset($_SERVER['COLLISION_PRINTER_COMPACT'])) {
                DefaultPrinter::compact(true);
            }

            if (isset($_SERVER['COLLISION_PRINTER_PROFILE'])) {
                DefaultPrinter::profile(true);
            }

            $subscribers = [
                // Configured
                new class($printer) extends Subscriber implements ConfiguredSubscriber
                {
                    public function notify(Configured $event): void
                    {
                        $this->printer()->setDecorated(
                            $event->configuration()->colors()
                        );
                    }
                },

                // Test
                new class($printer) extends Subscriber implements PrintedUnexpectedOutputSubscriber
                {
                    public function notify(PrintedUnexpectedOutput $event): void
                    {
                        $this->printer()->testPrintedUnexpectedOutput($event);
                    }
                },

                // Test Runner
                new class($printer) extends Subscriber implements ExecutionStartedSubscriber
                {
                    public function notify(ExecutionStarted $event): void
                    {
                        $this->printer()->testRunnerExecutionStarted($event);
                    }
                },

                new class($printer) extends Subscriber implements ExecutionFinishedSubscriber
                {
                    public function notify(ExecutionFinished $event): void
                    {
                        $this->printer()->testRunnerExecutionFinished($event);
                    }
                },

                // Test > Hook Methods

                new class($printer) extends Subscriber implements BeforeFirstTestMethodErroredSubscriber
                {
                    public function notify(BeforeFirstTestMethodErrored $event): void
                    {
                        $this->printer()->testBeforeFirstTestMethodErrored($event);
                    }
                },

                // Test > Lifecycle ...

                new class($printer) extends Subscriber implements FinishedSubscriber
                {
                    public function notify(Finished $event): void
                    {
                        $this->printer()->testFinished($event);
                    }
                },

                new class($printer) extends Subscriber implements PreparationStartedSubscriber
                {
                    public function notify(PreparationStarted $event): void
                    {
                        $this->printer()->testPreparationStarted($event);
                    }
                },

                // Test > Issues ...

                new class($printer) extends Subscriber implements ConsideredRiskySubscriber
                {
                    public function notify(ConsideredRisky $event): void
                    {
                        $this->printer()->testConsideredRisky($event);
                    }
                },

                new class($printer) extends Subscriber implements DeprecationTriggeredSubscriber
                {
                    public function notify(DeprecationTriggered $event): void
                    {
                        $this->printer()->testDeprecationTriggered($event);
                    }
                },

                new class($printer) extends Subscriber implements TestRunnerDeprecationTriggeredSubscriber
                {
                    public function notify(TestRunnerDeprecationTriggered $event): void
                    {
                        $this->printer()->testRunnerDeprecationTriggered($event);
                    }
                },

                new class($printer) extends Subscriber implements TestRunnerWarningTriggeredSubscriber
                {
                    public function notify(TestRunnerWarningTriggered $event): void
                    {
                        $this->printer()->testRunnerWarningTriggered($event);
                    }
                },

                new class($printer) extends Subscriber implements PhpDeprecationTriggeredSubscriber
                {
                    public function notify(PhpDeprecationTriggered $event): void
                    {
                        $this->printer()->testPhpDeprecationTriggered($event);
                    }
                },

                new class($printer) extends Subscriber implements PhpunitDeprecationTriggeredSubscriber
                {
                    public function notify(PhpunitDeprecationTriggered $event): void
                    {
                        $this->printer()->testPhpunitDeprecationTriggered($event);
                    }
                },

                new class($printer) extends Subscriber implements PhpNoticeTriggeredSubscriber
                {
                    public function notify(PhpNoticeTriggered $event): void
                    {
                        $this->printer()->testPhpNoticeTriggered($event);
                    }
                },

                new class($printer) extends Subscriber implements PhpWarningTriggeredSubscriber
                {
                    public function notify(PhpWarningTriggered $event): void
                    {
                        $this->printer()->testPhpWarningTriggered($event);
                    }
                },

                new class($printer) extends Subscriber implements PhpunitWarningTriggeredSubscriber
                {
                    public function notify(PhpunitWarningTriggered $event): void
                    {
                        $this->printer()->testPhpunitWarningTriggered($event);
                    }
                },

                new class($printer) extends Subscriber implements PhpunitErrorTriggeredSubscriber
                {
                    public function notify(PhpunitErrorTriggered $event): void
                    {
                        $this->printer()->testPhpunitErrorTriggered($event);
                    }
                },

                // Test > Outcome ...

                new class($printer) extends Subscriber implements ErroredSubscriber
                {
                    public function notify(Errored $event): void
                    {
                        $this->printer()->testErrored($event);
                    }
                },
                new class($printer) extends Subscriber implements FailedSubscriber
                {
                    public function notify(Failed $event): void
                    {
                        $this->printer()->testFailed($event);
                    }
                },
                new class($printer) extends Subscriber implements MarkedIncompleteSubscriber
                {
                    public function notify(MarkedIncomplete $event): void
                    {
                        $this->printer()->testMarkedIncomplete($event);
                    }
                },

                new class($printer) extends Subscriber implements NoticeTriggeredSubscriber
                {
                    public function notify(NoticeTriggered $event): void
                    {
                        $this->printer()->testNoticeTriggered($event);
                    }
                },

                new class($printer) extends Subscriber implements PassedSubscriber
                {
                    public function notify(Passed $event): void
                    {
                        $this->printer()->testPassed($event);
                    }
                },
                new class($printer) extends Subscriber implements SkippedSubscriber
                {
                    public function notifylements ErroredSubscriber
                {
                    public function notify(Errored $event): void
                    {
                        $this->printer()->testErrored($event);
                    }
                },
                new class($printer) extends Subscriber implements FailedSubscriber
                {
                    public function notify(Failed $event): void
                    {
                        $this->printer()->testFailed($event);
                    }
                },
                new class($printer) extends Subscriber implements MarkedIncompleteSubscriber
                {
                    public function notify(MarkedIncomplete $event): void
                    {
                        $this->printer()->testMarkedIncomplete($event);
                    }
                },

                new class($printer) extends Subscriber implements NoticeTriggeredSubscriber
                {
                    public function notify(N