string|int $amount)
 * @method static Money VES(numeric-string|int $amount)
 * @method static Money VET(numeric-string|int $amount)
 * @method static Money VGX(numeric-string|int $amount)
 * @method static Money VIB(numeric-string|int $amount)
 * @method static Money VIDT(numeric-string|int $amount)
 * @method static Money VITE(numeric-string|int $amount)
 * @method static Money VND(numeric-string|int $amount)
 * @method static Money VOXEL(numeric-string|int $amount)
 * @method static Money VTHO(numeric-string|int $amount)
 * @method static Money VUV(numeric-string|int $amount)
 * @method static Money WABI(numeric-string|int $amount)
 * @method static Money WAN(numeric-string|int $amount)
 * @method static Money WAVES(numeric-string|int $amount)
 * @method static Money WAXP(numeric-string|int $amount)
 * @method static Money WBTC(numeric-string|int $amount)
 * @method static Money WIN(numeric-string|int $amount)
 * @method static Money WING(numeric-string|int $amount)
 * @method static Money WNXM(numeric-string|int $amount)
 * @method static Money WOO(numeric-string|int $amount)
 * @method static Money WRX(numeric-string|int $amount)
 * @method static Money WST(numePK     g.s[ch2(  2(    Calculator/GmpCalculator.phpnu [        nt)
 * @method static Money XAF(numeric-string|int $amount)
 * @method static Money XAG(numeric-string|int $amount)
 * @method static Money XAU(numeric-string|int $amount)
 * @method static Money XBA(numeric-string|int $amount)
 * @method static Money XBB(numeric-string|int $amount)
 * @method static Money XBC(numeric-string|int $amount)
 * @method static Money XBD(numeric-string|int $amount)
 * @method static Money XBT(numeric-string|int $amount)
 * @method static Money XCD(numeric-string|int $amount)
 * @method static Money XDR(numeric-string|int $amount)
 * @method static Money XEC(numeric-string|int $amount)
 * @method static Money XEM(numeric-string|int $amount)
PK     g.s[ch2(  2(    Calculator/GmpCalculator.phpnu [        ney XMR(numeric-string|int $amount)
 * @method static Money XNO(numeric-string|int $amount)
 * @method static Money XOF(numeric-string|int $amount)
 * @method static Money XPD(numeric-string|int $amount)
 * @method static Money XPF(numeric-string|int $amount)
 * @method static Money XPT(numeric-string|int $amount)
 * @method static Money XRP(numeric-string|int $amount)
 * @method static Money XSU(numeric-string|int $amount)
 * @method static Money XTS(numeric-string|int $amount)
 * @method static Money XTZ(numeric-string|int $amount)
 * @method static Money XUA(numeric-string|int $amount)
 * @method static Money XVG(numeric-string|int $amount)
 * @method static Money XVS(numeric-string|int $amount)
 * @method static Money XXX(numeric-string|int $amount)
 * @method static Money YER(numeric-string|int $amount)
 * @method static Money YFI(numeric-string|int $amount)
 * @method static Money YFII(numeric-string|int $amount)
 * @method static Money YGG(numeric-string|int $amount)
 * @method static Money ZAR(numeric-string|int $amount)
 * @method static Money ZEC(numeric-string|int $amount)
 * @method static Money ZEN(numeric-string|int $amount)
 * @method static Money ZIL(numeric-string|int $amount)
 * @method static Money ZMW(numeric-string|int $amount)
 * @method static Money ZRX(numeric-string|int $amount)
 * @method static Money ZWL(numeric-string|int $amount)
 * @psalm-immutable
 */
trait MoneyFactory
{
    /**
     * Convenience factory method for a Money object.
     *
     * <code>
     * $fiveDPK     g.s[ch2(  2(    Calculator/GmpCalculator.phpnu [        s
     * @psalm-param non-empty-string          $method
     * @psalm-param array{numeric-string|int} $arguments
     *
     * @throws InvalidArgumentException If amount is not integer(ish).
     *
     * @psalm-pure
     */
    public static function __callStatic(string $method, array $arguments): Money
    {
        return new Money($arguments[0], new Currency($method));
    }
}
PK     g.s[ch2(  2(    Calculator/GmpCalculator.phpnu [        <?php

declare(strict_types=1);

namespace Money\Calculator;

use InvalidArgumentException as CoreInvalidArgumentException;
use Money\Calculator;
use Money\Exception\InvalidArgumentException;
use Money\Money;
use Money\Number;

use function gmp_add;
use function gmp_cmp;
use function gmp_div_q;
use function gmp_div_qr;
use function gmp_init;
use function gmp_mod;
use function gmp_mul;
use function gmp_neg;
use function gmp_strval;
use function gmp_sub;
use function ltrim;
use function str_pad;
use function str_replace;
use function strlen;
use function substr;

use const GMP_ROUND_MINUSINF;
use const STR_PAD_LEFT;

/**
 * @psalm-immutable
 *
 * Important: the {@see GmpCalculator} is not optimized for decimal operations, as GMP
 *            is designed to operate on large integers. Consider using this only if your
 *            system does not have `ext-bcmath` installed.
 */
final class GmpCalculator implements Calculator
{
    private const SCALE = 14;

    /** @psalm-pure */
    public static function compare(string $a, string $b): int
    {
        $aNum = Number::fromString($a);
        $bNum = Number::fromString($b);

        if ($aNum->isDecimal() || $bNum->isDecimal()) {
            $integersCompared = gmp_cmp($aNum->getIntegerPart(), $bNum->getIntegerPart());
            if ($integersCompared !== 0) {
                return $integersCompared;
            }

            $aNumFractional = $aNum->getFractionalPart() === '' ? '0' : $aNum->getFractionalPart();
            $bNumFractional = $bNum->getFractionalPart() === '' ? '0' : $bNum->getFractionalPart();

            return gmp_cmp($aNumFractional, $bNumFractional);
        }

        return gmp_cmp($a, $b);
    }

    /** @psalm-pure */
    public static function add(string $amount, string $addend): string
    {
        return gmp_strval(gmp_add($amount, $addend));
    }

    /** @psalm-pure */
    public static function subtract(string $amount, string $subtrahend): string
    {
        return gmp_strval(gmp_sub($amount, $subtrahend));
    }

    /** @psalm-pure */
    public static function multiply(string $amount, string $multiplier): string
    {
        $multiplier = Number::fromString($multiplier);

        if ($multiplier->isDecimal()) {
            $decimalPlaces  = strlen($multiplier->getFractionalPart());
            $multiplierBase = $multiplier->getIntegerPart();
            $negativeZero   = $multiplierBase === '-0';

            if ($negativeZero) {
                $multiplierBase = '-';
            }

            if ($multiplierBase) {
                $multiplierBase .= $multiplier->getFractionalPart();
            } else {
                $multiplierBase = ltrim($multiplier->getFractionalPart(), '0');
            }

            $resultBase = gmp_strval(gmp_mul(gmp_init($amount), gmp_init($multiplierBase)));

            if ($resultBase === '0') {
                return '0';
            }

            $result       = substr($resultBase, $decimalPlaces * -1);
            $resultLength = strlen($result);
            if ($decimalPlaces > $resultLength) {
                /** @psalm-var numeric-string $finalResult */
                $finalResult = '0.' . str_pad('', $decimalPlaces - $resultLength, '0') . $result;

                return $finalResult;
            }

            /** @psalm-var numeric-string $finalResult */
            $finalResult = substr($resultBase, 0, $decimalPlaces * -1) . '.' . $result;

            if ($negativeZero) {
                /** @psalm-var numeric-string $finalResult */
                $finalResult = str_replace('-.', '-0.', $finalResult);
            }

            return $finalResult;
        }

        return gmp_strval(gmp_mul(gmp_init($amount), gmp_init((string) $multiplier)));
    }

    /** @psalm-pure */
    public static function divide(string $amount, string $divisor): string
    {
        if (self::compare($divisor, '0') === 0) {
            throw InvalidArgumentException::divisionByZero();
        }

        $divisor = Number::fromString($divisor);

        if ($divisor->isDecimal()) {
            $decimalPlaces = strlen($divisor->getFractionalPart());
            $divisorBase   = $divisor->getIntegerPart();
            $negativeZero  = $divisorBase === '-0';

            if ($negativeZero) {
                $divisorBase = '-';
            }

            if ($divisor->getIntegerPart()) {
                $divisor = new Number($divisorBase . $divisor->getFractionalPart());
            } else {
                $divisor = new Number(ltrim($divisor->getFractionalPart(), '0'));
            }

            $amount = gmp_strval(gmp_mul(gmp_init($amount), gmp_init('1' . str_pad('', $decimalPlaces, '0'))));
        }

        [$integer, $remainder] = gmp_div_qr(gmp_init($amount), gmp_init((string) $divisor));

        if (gmp_cmp($remainder, '0') === 0) {
            return gmp_strval($integer);
        }

        $divisionOfRemainder = gmp_strval(
            gmp_div_q(
                gmp_mul($remainder, gmp_init('1' . str_pad('', self::SCALE, '0'))),
                gmp_init((string) $divisor),
                GMP_ROUND_MINUSINF
            )
        );

        if ($divisionOfRemainder[0] === '-') {
            $divisionOfRemainder = substr($divisionOfRemainder, 1);
        }

        /** @psalm-var numeric-string $finalResult */
        $finalResult = gmp_strval($integer) . '.' . str_pad($divisionOfRemainder, self::SCALE, '0', STR_PAD_LEFT);

        return $finalResult;
    }

    /** @psalm-pure */
    public static function ceil(string $number): string
    {
        $number = Number::fromString($number);

        if ($number->isInteger()) {
            return $number->__toString();
        }

        if ($number->isNegative()) {
            return self::add($number->getIntegerPart(), '0');
        }

        return self::add($number->getIntegerPart(), '1');
    }

    /** @psalm-pure */
    public static function floor(string $number): string
    {
        $number = Number::fromString($number);

        if ($number->isInteger()) {
            return $number->__toString();
        }

        if ($number->isNegative()) {
            return self::add($number->getIntegerPart(), '-1');
        }

  