    }
        // @codeCoverageIgnoreEnd

        return $complexityCalculatingVisitor->result();
    }

    private function parser(): Parser
    {
        return (new ParserFactory)->cPK     
0s[rY      FunctionUnit.phpnu [        h.s[YW  W    MoneyParser.phpnu [        <?php

declare(strict_types=1);

namespace Money;

/**
 * Parses a string into a Money object.
 */
interface MoneyParser
{
    /**
     * Parses a string into a Money object (including currency).
     *
     * @throws Exception\ParserException
     */
    public function parse(string $money, Currency|null $fallbackCurrency = null): MoPK     
0s[      FileUnit.phpnu [                <?php declare(strict_types=1);
/*
 * This file is partPK     
0s[J      ClassMethodUnit.phpnu [        punit.de>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace SebastianBergmann\CodeUnit;

/**
 * @psalm-immutable
 */
final class FunctionUnit extends CodeUnit
{
    /**
     * @psalm-assert-if-true FunctionUnit $this
     */
    public function isFunction(): bool
    {
      PK     
0s[=i30  30    CodeUnit.phpnu [        thodUnit.phpnu [        <?php declare(strict_types=1);
/*
 * This file is part of sebasPK     
0s[N'      CodeUniPK     
0s[      FileUnit.phpnu [        and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace SebastianBergmann\CodeUnit;

/**
 * @psalm-immutable
 */
final class ClassMethodUnit extends CodeUnit
{
    /**
     * @psalm-assert-if-true ClassMethodUnit $this
     */
    public function isClassMethod(): bool
    {
        return true;
    }
}
PK     
0s[N'      CodeUnitCollection.phpnu [        <?php declare(strict_types=1);
/*
 * This file is part of sebastian/cPK     
0s[=i30  30    CodeUnit.phpnu [        >
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace SebastianBergmann\CodeUnit;

use function array_merge;
use function count;
use Countable;
use IteratorAggregate;

/**
 * @template-implements IteratorAggregate<int, CodeUnit>
 *
 * @psalm-immutable
 */
final class CodeUnitCollection implements Countable, IteratorAggregate
{
    /**
     * @psalm-var list<CodeUnit>
     */
    private readonly array $codeUnits;

    public static function fromList(CodeUnit ...$codeUnits): self
    {
        return new self($codeUnits);
    }

    /**
     * @psalm-param list<CodeUnit> $codeUnits
     */
    private function __construct(array $codeUnits)
    {
        $this->codeUnits = $codeUnits;
    }

    /**
     * @psalm-return list<CodeUnit>
     */
    public function asArray(): array
    {
        return $this->codeUnits;
    }

    public function getIterator(): CodeUnitCollectPK     
0s[      FileUnit.phpnu [        tor($this);
    }

    public function count(): int
    {
        return count($this->codeUnits);
    }

    public function isEmpty(): bool
    {
        return empty($this->codeUnits);
    }

    public function mergeWith(self $other): self
    {
        return new self(
            array_merge(
                $this->asArray(),
                $other->asArray()
            )
        );
    }
}
PK     
0s[      FileUnit.phpnu [        <?php declare(strict_types=1);
/*
 * This PK     
0s[=i30  30    CodeUnit.phpnu [        gmann <sebastian@phpunit.de>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace SebastianBergmann\CodeUnit;

/**
 * @psalm-immutable
 */
final class FileUnit extends CodeUnit
{
    /**
     * @psalm-assert-if-true FileUnit $this
     */
    public function isFile(): bool
    {
        return true;
    }
}
PK     
0s[=i30  30    CodeUnit.phpnu [        <?php declare(strict_types=1);
/*
 * This file is part of sebastian/code-unit.
 *
 * (c) Sebastian Bergmann <sebastian@phpunit.de>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace SebastianBergmann\CodeUnit;

use function count;
use function file;
use function file_exists;
use function is_readable;
use function range;
use function sprintf;
use ReflectionClass;
use ReflectionFunction;
use ReflectionMethod;

/**
 * @psalm-immutable
 */
abstract class CodeUnit
{
    private readonly string $name;
    private readonly string $sourceFileName;

    /**
     * @psalm-var list<int>
     */
    private readonly array $sourceLines;

    /**
     * @psalm-param class-string $className
     *
     * @throws InvalidCodeUnitException
     * @throws ReflectionException
     */
    public static function forClass(string $className): ClassUnit
    {
        self::ensureUserDefinedClass($className);

        $reflector = self::reflectorForClass($className);

        return new ClassUnit(
            $className,
            $reflector->getFileName(),
            range(
                $reflector->getStartLine(),
                $reflector->getEndLine()
            )
        );
    }

    /**
     * @psalm-param class-string $className
     *
     * @throws InvalidCodeUnitException
     * @throws ReflectionException
     */
    public static function forClassMethod(string $className, string $methodName): ClassMethodUnit
    {
        self::ensureUserDefinedClass($className);

        $reflector = self::reflectorForClassMethod($className, $methodName);

        return new ClassMethodUnit(
            $className . '::' . $methodName,
            $reflector->getFileName(),
            range(
                $reflector->getStartLine(),
                $reflector->getEndLine()
            )
        );
    }

    /**
     * @throws InvalidCodeUnitException
     */
    public static function forFileWithAbsolutePath(string $path): FileUnit
    {
        self::ensureFileExistsAndIsReadable($path);

        return new FileUnit(
            $path,
            $path,
            range(
                1,
                count(file($path))
            )
        );
    }

    /**
     * @psalm-param class-string $interfaceName
     *
     * @throws InvalidCodeUnitException
     * @throws ReflectionException
     */
    public static function forInterface(string $interfaceName): InterfaceUnit
    {
        self::ensureUserDefinedInterface($interfaceName);

        $reflector = self::reflectorForClass($interfaceName);

        return new InterfaceUnit(
            $interfaceName,
            $reflector->getFileName(),
            range(
                $reflector->getStartLine(),
                $reflector->getEndLine()
            )
        );
    }

    /**
     * @psalm-param class-string $interfaceName
     *
     * @throws InvalidCodeUnitException
     * @throws ReflectionException
     */
    public static function forInterfaceMethod(string $interfaceName, string $methodName): InterfaceMethodUnit
    {
        self::ensureUserDefinedInterface($interfaceName);

        $reflector = self::reflectorForClassMethod($interfaceName, $methodName);

        return new InterfaceMethodUnit(
            $interfaceName . '::' . $methodName,
            $reflector->getFileName(),
            range(
                $reflector->getStartLine(),
                $reflector->getEndLine()
            )
        );
    }

    /**
     * @psalm-param class-string $traitName
     *
     * @throws InvalidCodeUnitException
     * @throws ReflectionException
     */
    public static function forTrait(string $traitName): TraitUnit
    {
        self::ensureUserDefinedTrait($traitName);

        $reflector = self::reflectorForClass($traitName);

        return new TraitUnit(
            $traitName,
            $reflector->getFileName(),
            range(
                $reflector->getStartLine(),
                $reflector->getEndLine()
            )
        );
    }

    /**
     * @psalm-param class-string $traitName
     *
     * @throws InvalidCodeUnitException
     * @throws ReflectionException
     */
    public static function forTraitMethod(string $traitName, string $methodName): TraitMethodUnit
    {
        self::ensureUserDefinedTrait($traitName);

        $reflector = self::reflectorForClassMethod($traitName, $methodName);

        return new TraitMethodUnit(
            $traitName . '::' . $methodName,
            $reflector->getFileName(),
            range(
                $reflector->getStartLine(),
                $reflector->getEndLine()
            )
        );
    }

    /**
     * @psalm-param callable-string $functionName
     *
     * @throws InvalidCodeUnitException
     * @throws ReflectionException
     */
    public static function forFunction(string $functionName): FunctionUnit
    {
        $reflector = self::reflectorForFunction($functionName);

        if (!$reflector->isUserDefined()) {
            throw new InvalidCodeUnitException(
                sprintf(
                    '"%s" is not a user-defined function',
                    $functionName
                )
            );
        }

        return new FunctionUnit(
            $functionName,
            $reflector->getFileName(),
            range(
                $reflector->getStartLine(),
                $reflector->getEndLine()
            )
        );
    }

    /**
     * @psalm-param list<int> $sourceLines
     */
    private function __construct(string $name, string $sourceFileName, array $sourceLines)
    {
        $this->name           = $name;
        $this->sourceFileName = $sourceFileName;
        $this->sourceLines    = $sourceLines;
    }

    public function name(): string
    {
        return $this->name;
    }

    public function sourceFileName(): string
    {
        return $this->sourceFileName;
    }

    /**
     * @psalm-return list<int>
     */
    public function sourceLines(): array
    {
        return $this->sourceLines;
    }

    public function isClass(): bool
    {
        return false;
    }

    public function isClassMethod(): bool
    {
        return false;
    }

    public function isInterface(): bool
    {
        return false;
    }

    public function isInterfaceMethod(): bool
    {
        return false;
    }

    public function isTrait(): bool
    {
        return false;
    }

    public function isTraitMethod(): bool
    {
        return false;
    }

    public function isFunction(): bool
    {
        return false;
    }

    public function isFile(): bool
    {
        return false;
    }

    /**
     * @throws InvalidCodeUnitException
     */
    private static function ensureFileExistsAndIsReadable(string $path): void
    {
        if (!(file_exists($path) && is_readable($path))) {
            throw new InvalidCodeUnitException(
                sprintf(
                    'File "%s" does not exist or is not readable',
                    $path
                )
            );
        }
    }

    /**
     * @psalm-param class-string $className
     *
     * @throws InvalidCodeUnitException
     */
    private static function ensureUserDefinedClass(string $className): void
    {
        try {
            $reflector = new ReflectionClass($className);

            if ($reflector->isInterface()) {
                throw new InvalidCodeUnitException(
                    sprintf(
                        '"%s" is an interface and not a class',
                        $className
                    )
                );
            }

            if ($reflector->isTrait()) {
                throw new InvalidCodeUnitException(
                    sprintf(
                        '"%s" is a trait and not a class',
                        $className
                    )
                );
            }

            if (!$reflector->isUserDefined()) {
                throw new InvalidCodeUnitException(
                    sprintf(
                        '"%s" is not a user-defined class',
                        $className
                    )
                );
            }
            // @codeCoverageIgnoreStart
        } catch (\Reflec