terminal()->lines() - $reservedLines);
    }

    /**
     * Highlight the given index.
     */
    protected function highlight(?int $index): void
    {
        $this->highlighted = $index;

        if ($this->highlighted === null) {
            return;
        }

        if ($this->highlighted < $this->firstVisible) {
            $this->firstVisible = $this->highlighted;
        } elseif ($this->highlighted > $this->firstVisible + $this->scroll - 1) {
            $this->firstVisible = $this->highlighted - $this->scroll + 1;
        }
    }

    /**
     * Highlight the previous entry, or wrap around to the last entry.
     */
    protected function highlightPrevious(int $total, bool $allowNull = false): void
    {
        if ($total === 0) {
            return;
        }

        if ($this->highlighted === null) {
            $this->highlight($total - 1);
        } elseif ($this->highlighted === 0) {
            $this->highlight($allowNull ? null : ($total - 1));
        } else {
            $this->highlight($this->highlighted - 1);
        }
    }

    /**
     * Highlight the next entry, or wrap around to the first entry.
     */
    protected function highlightNext(int PK     M)s[L      Concerns/Colors.phpnu [         0) {
            return;
        }

        if ($this->highlighted === $total - 1) {
            $this->highlight($allowNull ? null : 0);
        } else {
            $this->highlight(($this->highlighted ?? -1) + 1);
        }
    }

    /**
     * Center the highlighted option.
     */
    protectedPK     M)s[L      Concerns/Colors.phpnu [        this->highlighted < $this->scroll) {
            return;
        }

        $remaining = $total - $this->highlighted - 1;
        $halfScroll = (int) floor($this->scroll / 2);
        $endOffset = max(0, $halfScroll - $remaining);

        if ($this->scroll % 2 === 0) {
            $endOffset--;
        }

        PK     M)s[L      Concerns/Colors.phpnu [        ;
    }
}
PK     M)s[L      Concerns/Colors.phpnu [        <?php

namespace Laravel\Prompts\Concerns;

trait Colors
{
    /**
     * Reset all colors and styles.
     */
    public function reset(string $text): string
    {
        return "\e[0m{$text}\e[0m";
    }

    /**
     * Make the text bold.
     */
    public function bold(string $text): string
    {
        return "\e[1m{$text}\e[22m";
    }

    /**
     * Make the text dim.
     */
    public function dim(string $text): string
    {
        return "\e[2m{$text}\e[22m";
    }

    /**
     * Make the text italic.
     */
    public function italic(string $text): string
    {
        return "\e[3m{$text}\e[23m";
    }

    /**
     * Underline the text.
     */
    public function underline(string $text): string
    {
        return "\e[4m{$text}\e[24m";
    }

    /**
     * Invert the text and background colors.
     */
    public function inverse(string $text): string
    {
        return "\e[7m{$text}\e[27m";
    }

    /**
     * Hide the text.
     */
    public function hidden(string $text): string
    {
        return "\e[8m{$text}\e[28m";
    }

    /**
     * Strike through the text.
     */
    public function strikethrough(string $text): string
    {
        return "\e[9m{$text}\e[29m";
    }

    /**
     * Set the text color to black.
     */
    public function black(string $text): string
    {
        return "\e[30m{$text}\e[39m";
    }

    /**
     * Set the text color to red.
     */
    public function red(string $text): string
    {
        return "\e[31m{$text}\e[39m";
    }

    /**
     * Set the text color to green.
     */
    public function green(string $text): string
    {
        return "\e[32m{$text}\e[39m";
    }

    /**
     * Set the text color to yellow.
     */
    public function yellow(