        return __DIR__ . "/../resources/views/{$viewName}.php";
    }

    /**
     * Add custom HTML which will be added to the head tag of the error page.
     */
    public function addCustomHtmlToHead(string $html): self
    {
        $this->customHtmlHead .= $html;

        return $this;
    }

    /**
     * Add custom HTML which will be added to the body tag of the error page.
     */
    public function addCustomHtmlToBody(string $html): self
    {
        $this->customHtmlBody .= $html;

        return $this;
    }

    protected function setUpFlare(): self
    {
        if (! $this->flare->apiTokenSet()) {
            $this->flare->setApiToken($this->flareApiKey ?? '');
        }

        $this->flare->setContextProviderDetector($this->contextProviderDetector);

        foreach ($this->middleware as $singleMiddleware) {
            $this->flare->registerMiddleware($singleMiddleware);
        }

        if ($this->applicationPath !== '') {
            $this->flare->applicationPath($this->applicationPath);
        }

        return $this;
    }

    /** @return array<class-string<HasSolutionsForThrowable>> */
    protected function getDefaultSolutionProviders(): array
    {
        return [
            BadMethodCallSolutionProvider::class,
            MergeConflictSolutionProvider::class,
            UndefinedPropertySolutionProvider::class,
        ];
    }

    protected function createReport(Throwable $throwable): Report
    {
        return $this->flare->createReport($throwable);
    }
}
PK     Ps[o      Config/IgnitionConfig.phpnu [        <?php

namespace Spatie\Ignition\Config;

use Illuminate\Contracts\Support\Arrayable;
use Spatie\Ignition\Contracts\ConfigManager;
use Throwable;

/** @implements Arrayable<string, string|null|bool|array<string, mixed>> */
class IgnitionConfig implements Arrayable
{
    private ConfigManager $manager;

    public static function loadFromConfigFile(): self
    {
        return (new self())->loadConfigFile();
    }

    /**
     * @param array<string, mixed> $options
     */
    public function __construct(protected array $options = [])
    {
        $defaultOptions = $this->getDefaultOptions();

        $this->options = array_merge($defaultOptions, $options);
        $this->manager = $this->initConfigManager();
    }

    public function setOption(string $name, string $value): self
    {
        $this->options[$name] = $value;

        return $this;
    }

    private function initConfigManager(): ConfigManager
    {
        try {
            /** @phpstan-ignore-next-line  */
            return app(ConfigManager::class);
        } catch (Throwable) {
            return new FileConfigManager();
        }
    }

    /** @param array<string, string> $options */
    public function merge(array $options): self
    {
        $this->options = array_merge($this->options, $options);

        return $this;
    }

    public function loadConfigFile(): self
    {
        $this->merge($this->getConfigOptions());

        return $this;
    }

    /** @return array<string, mixed> */
    public function getConfigOptions(): array
    {
        return $this->manager->load();
    }

    /**
     * @param array<string, mixed> $options
     * @return bool
     */
    public function saveValues(array $options): bool
    {
        return $this->manager->save($options);
    }

    public function hideSolutions(): bool
    {
        return $this->options['hide_solutions'] ?? false;
    }

    public function editor(): ?string
    {
        return $this->options['editor'] ?? null;
    }

    /**
     * @return array<string, mixed> $options
     */
    public function editorOptions(): array
    {
        return $this->options['editor_options'] ?? [];
    }

    public function remoteSitesPath(): ?string
    {
        return $this->options['remote_sites_path'] ?? null;
    }

    public function localSitesPath(): ?string
    {
        return $this->options['local_sites_path'] ?? null;
    }

    public function theme(): ?string
    {
        return $this->options['theme'] ?? null;
    }

    public function shareButtonEnabled(): bool
    {
        return (bool)($this->options['enable_share_button'] ?? false);
    }

    public function shareEndpoint(): string
    {
        return $this->options['share_endpoint']
            ?? $this->getDefaultOptions()['share_endpoint'];
    }

    public function runnableSolutionsEnabled(): bool
    {
        return (bool)($this->options['enable_runnable_solutions'] ?? false);
    }

    /** @return array<string, string|null|bool|array<string, mixed>> */
    public function toArray(): array
    {
        return [
            'editor' => $this->editor(),
            'theme' => $this->theme(),
            'hideSolutions' => $this->hideSolutions(),
     pstorm' => [
                    'label' => 'PhpStorm',
                    'url' => 'phpstorm://open?file=%path&line=%line',
                ],
                'phpstorm-remote' => [
                    'label' => 'PHPStorm Remote',
                    'url' => 'javascript:r = new XMLHttpRequest;r.open("get", "http://localhost:63342/api/file/%path:%line");r.send()',
                ],
                'idea' => [
                    'label' => 'Idea',
                    'url' => 'idea://open?file=%path&line=%line',
                ],
                'vscode' => [
                    'label' => 'VS Code',
                    'url' => 'vscode://file/%path:%line',
                ],
                'vscode-insiders' => [
                    'label' => 'VS Code Insiders',
                    'url' => 'vscode-insiders://file/%path:%line',
                ],
                'vscode-remote' => [
                    'label' => 'VS Code Remote',
                    'url' => 'vscode://vscode-remote/%path:%line',
                ],
                'vscode-insiders-remote' => [
                    'label' => 'VS Code Insiders Remote',
                    'url' => 'vscode-insiders://vscode-remote/%path:%line',
                ],
                'vscodium' => [
                    'label' => 'VS Codium',
                    'url' => 'vscodium://file/%path:%line',
                ],
                'atom' => [
                    'label' => 'Atom',
                    'url' => 'atom://core/open/file?filename=%path&line=%line',
                ],
                'nova' => [
                    'label' => 'Nova',
                    'url' => 'nova://open?path=%path&line=%line',
                ],
                'netbeans' => [
                    'label' => 'NetBeans',
                    'url' => 'netbeans://open/?f=%path:%line',
                ],
                'xdebug' => [
                    'label' => 'Xdebug',
                    'url' => 'xdebug://%path@%line',
                ],
            ],
        ];
    }
}
