         'route' => $route->getName(),
            'routeParameters' => $this->getRouteParameters(),
            'controllerAction' => $route->getActionName(),
            'middleware' => array_values($route->gatherMiddleware() ?? []),
        ];
    }

    /** @return array<int, mixed> */
    protected function getRouteParameters(): array
    {
        try {
            /** @phpstan-ignore-next-line */
            return collect(optional($this->request->route())->parameters ?? [])
                ->map(fn ($parameter) => $parameter instanceof Model ? $parameter->withoutRelations() : $parameter)
                ->map(function ($parameter) {
                    return method_exists($parameter, 'toFlare') ? $parameter->toFlare() : $parameter;
                })
                ->toArray();
        } catch (Throwable) {
            return [];
        }
    }

    /** @return array<int, mixed> */
    public function 