f an other CurrencyPair has the same parameters as this.
     */
    public function equals(CurrencyPair $other): bool
    {
        return $this->baseCurrency->equals($other->baseCurrency)
            && $this->counterCurrency->equals($other->counterCurrency)PK     h.s[      Currencies.phpnu [        atio;
    }

    /**
     * {@inheritdoc}
     *
     * @psalm-return array{baseCurrency: Currency, counterCurrency: Currency, ratio: numeric-string}
     */
    public function jsonSerialize(): array
    {
        return [
            'baseCurrency' => $this->baseCurrency,
            'counterCurrency' => $this->counterCurrency,
            'ratio' => $this->conversionRatio,
        ];
    }
}
PK     h.s[      Currencies.phpnu [        <?php

declare(strict_types=1);

namespace Money;

use IteratorAggregate;
use Money\Exception\UnknownCurrencyException;
use Traversable;

/**
 * Implement this to provide a list of currencies.
 */
interface Currencies extends IteratorAggregate
{
    /**
     * ChecksPK     h.s[8=u	  u	  
  Converter.phpnu [         */
    public function contains(Currency $currency): bool;

    /**
  PK     h.s[hW      Currencies/CachedCurrencies.phpnu [        xception If currency is not available in the current context.
     */
    public function subunitFor(Currency $currency): int;

    /**
     * @psalm-return Traversable<int|string, Currency>
     */
    public function getIterator(): Traversable;
}
PK     h.s[8=u	  u	  
  Converter.phpnu [        <?php

declare(strict_types=1);

namespace Money;

use InvalidArgumentException;

use function sprintf;

/**
 * Provides a way to convert Money to Money in another Currency using an exchange rate.
 */
final class Converter
{
    private Currencies $currencies;

    private Exchange $exchange;

    public function __construct(Currencies $currencies, Exchange $exPK     h.s[hW      Currencies/CachedCurrencies.phpnu [          = $exchange;
    }

    public function convert(Money $money, Currency $counterCurrency, int $roundingMode = Money::ROUND_HALF_UP): Money
    {
        return $this->convertAgainstCurrencyPair(
            $money,
            $thi