ies->contains($currency)) {
                return $currencies->subunitFor($currency);
            }
        }

        throw new UnknownCurrencyException('Cannot find currency ' . $currency->getCode());
    }

    /** {@inheritDoc} */
    public function getItePK     h.s[<y  y    Currencies/ISOCurrencies.phpnu [        <int|string, Currency> $iterator */
        $iterator = new AppendIterator();

        foreach ($this->currencies as $currencies) {
            $currencyIterator = $currencies->getIterator();
            /** @psalm-var AppendIterator&Traversable<int|string, Currency> $currencyIterator */
            $iterator->append($currencyIterator);
        }

        return $iterator;
    }
}
PK     h.s[<y  y    Currencies/ISOCurrencies.phpnu [        <?php

declare(strict_types=1);

namespace Money\Currencies;

use ArrayIterator;
use Money\Currencies;
use Money\Currency;
use Money\Exception\UnknownCurrencyException;
use RuntimeException;
use Traversable;

use function array_keys;
use function array_map;
use function is_file;

/**
 * List of supported ISO 4217 currency codes and names.
 */
final class ISOCurrencies implements CPK     h.s[ i	  	    Currencies/CryptoCurrencies.phpnu [         * @psalm-var non-empty-array<non-empty-string, array{
     *     alphabeticCode: non-empty-string,
     *     currency: non-empty-string,
     *     minorUnit: positive-int|0,
     *     numericCode: positive-int
     * }>|null
     */
    private static ?array $currencies = null;

    public function contains(Currency $currency): bool
    {
        return isset($this->getCurrencies()[$currency->getCode()]);
    }

    public function subunitFor(Currency $currency): int
    {
        if (! $this->contains($currency)) {
            throw new UnknownCurrencyException('Cannot find ISO currency ' . $currency->getCode());
        }

        return $this->getCurrencies(PK     h.s[ i	  	    Currencies/CryptoCurrencies.phpnu [         code for a currency.
     *
     * @throws UnknownCurrencyException If currency is not available in the current context.
     */
    public function numericCodeFor(Currency $currency): int
    {
        if (! $this->contains($currency)) {
            throw new UnknownCurrencyException('Cannot find ISO currency ' . $currency->getCode());
        }

        return $this->getCurrencies()[$currency->getCode()]['numericCode'];
    }

    /**
     * @psalm-return Traversable<int, Curren