$counterCurrency
            ),
            $roundingMode
        );
    }

    /** @return array{0: Money, 1: CurrencyPair} */
    public function convertAndReturnWithCurrencyPair(Money $money, Currency $counterCurrency, int $roundingMode = Money::ROUND_HALF_UP): array
    {
        $pair = $this->exchange->quote(
            $money->getCurrency(),
            $counterCurrency
        );

        return [$this->convertAgainstCurrencyPair($money, $pair, $roundingMode), $pair];
    }

    public function convertAgainstCurrencyPair(Money $money, CurrencyPair $currencyPair, int $roundingMode = Money::ROUND_HALF_UP): Money
    {
        if (! $money->getCurrency()->equals($currencyPair->getBaseCurrency())) {
            throw new InvalidArgumentException(
                sprintf(
                    'Expecting to convert against base currency %s, but got %s instead',
                    $money->getCurrency()->getCode(),
                    $currencyPair->getBaseCurrency()->getCode()
                )
            );
        }

        $ratio                  = $currencyPair->getConversionRatio();
        $baseCurrencySubunit    = $this->currencies->subunitFor($currencyPaiPK     h.s[z	y  y    Currencies/CurrencyList.phpnu [        urrencies.phpnu [        ounterCurrency());
        $subunitDifference      = $baseCurrencySubunit - $counterCurrencySubunit;

        