 ArrayIterator;
use Money\Currencies;
use Money\Currency;
use Money\Exception\UnknownCurrencyException;
use Traversable;

use function array_keys;
use function array_map;

/**
 * A list of custom currencies.
 */
final class CuPK     h.s[Ɨ\  \  "  Currencies/AggregateCurrencies.phpnu [        units indexed by code.
     *
     * @psalm-var array<non-empty-string, int>
     */
    private array $currencies;

    /** @psalm-param array<non-empty-string, positive-int|0> $currencies */
    public function __construct(array $currencies)
    {
        $this->currencies = $currencies;
    }

    public function contains(Currency $currency): bool
    {
        return isset($this->currencies[$currency->getCode()]);
    }

    public function subunitFor(Currency $currency): int
    {
        if (! $this->contains($currency)) {
            throw new UnknownCurrPK     h.s[`sd  d     Currencies/BitcoinCurrencies.phpnu [          return $this->currencies[$currency->getCode()];
    }

    /** {@inheritDoc} */
    public function getIterator(): Traversable
    {
        return new ArrayIterator(
            array_map(
                static function ($coPK     h.s[<y  y    Currencies/ISOCurrencies.phpnu [                     array_keys($this->currencies)
            )
        );
    }
}
PK     h.s[`sd  d     Currencies/BitcoinCurrencies.phpnu [        <?php

declare(strict_types=1);

namespace Money\Currencies;

use ArrayIterator;
use Money\Currencies;
use Money\Currency;
use Money\Exception\UnknownCurrencyException;
use Traversable;

final class BitcoinCurrencies implements Currencies
{
    public const CODE = 'XBT';

    public const SYMBOL = "\xC9\x83";

    public function contains(Currency $currency): bool
    {
        return $currency->getCode()PK     h.s[Ɨ\  \  "  Currencies/AggregateCurrencies.phpnu [          {
        if ($currency->getPK     h.s[<y  y    Currencies/ISOCurrencies.phpnu [        rency->getCode() . ' is not bitcoin and is not supported by this currency repository');
        }

        return 8;
    }

    /** {@inheritDoc} */
    public function getIterator(): Traversable
    {
        return new ArrayIterator([new Currency(self::CODE)]);
    }
}
PK     h.s[Ɨ\  \  "  Currencies/AggregateCurrencies.phpnu [        <?php

declare(strict_types=1);

namespace Money\Currencies;

use AppendIterator;
use Money\Currencies;
use Money\Currency;
use Money\Exception\UnknownCurrencyException;
use Traversable;

/**
 * Aggregates several currency repositories.
 */
final class AggregateCurrencies implements Currencies
{
    /** @var Currencies[] */
    private array $currencies;

    /**
     * @param Currencies[] $currencies
     */
    public function __construct(array $currencies)
    {
        $this->currencies = $currencies;
    }

    public function contains(Currency $currency): bool
    {
        foreach ($this->currencies as $currencies) {
            if ($currencies->contains($currency)) {
                return true;
            }
        }

        return false;
    }

    public function subunitFor(Currency $currency): int
    