urceComparator.phpnu [        (c) Sebastian Bergmann <sebastian@phpunit.de>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace SebastianBergmann\Comparator;

use function assert;
use SebastianBergmann\Exporter\Exporter;
use SplObjectStorage;

final class SplObjectStorageComparator extends Comparator
{
    public function accepts(mixed $expected, mixed $actual): bool
    {
        return $expected instanceof SplObjectStorage && $actual instanceof SplObjectStorage;
    }

    /**
     * @throws ComparisonFailure
     */
    public function assertEquals(mixed $expected, mixed $actual, float $delta = 0.0, bool $canoPK     -s[      ResourceComparator.phpnu [        ($expected instanceof SplObjectStorage);
        assert($actual instanceof SplObjectStorage);

        $exporter = new Exporter;

        foreach ($actual as $object) {
            if (!$expected->contains($object)) {
                throw new ComparisonFailure(
                    $expected,
                    $actual,
                    $exporter->export($expected),
                    $exporter-PK     -s[G3WB	  B	    DOMNodeComparator.phpnu [        cts are ePK     -s[2h      ExceptionComparator.phpnu [        pected as $object) {
            if (!$actual->contains($object)) {
                throw new ComparisonFailure(
                    $expected,
                    $actual,
                    $exporter->export($expected),
                    $exporter->export($actual),
                    'Failed asserting that two objects are equal.'
                );
            }
        }
    }
}
PK     -s[2h      ExceptionComparator.phpnu [        <?php declare(strict_types=1);
/*
 * This file is part of sebastian/comparator.
 *
 * (c) Sebastian Bergmann <sebastian@phpunit.de>
 *
 * For tPK     -s[G3WB	  B	    DOMNodeComparator.phpnu [         file that was distributed with this source code.
 */
namespace SebastianBergmann\Comparator;

use function assert;
use Exception;

/**
 * Compares Exception instances for equality.
 */
final class ExceptionComparator extends ObjectComparator
{
    public function accepts(mixed $expected, mixed $actual)PK     -s[      ResourceComparator.phpnu