nvertToMoney($amount)->isPositive();
    }

    /**
     * Is a monetary amount less than zero?
     *
     * @param mixed $amount a monetary amount
     */
    public function isNegative(mixed $amount): bool
    {
        return $this->convertToMoney($amount)->isNegative();
    }

    /**
     * Returns the lowest of a series of monetary amounts.
     *
     * @param mixed $amount     a monetary amount
     * @param mixed ...$amounts additional monetary amounts
     */
    public function min(mixed $amount, mixed ...$amounts): string
    {
        return $this->convertToString(
            Money::min(
                $this->convertToMoney($amount),
                ...$this->convertToMoneyArray($amounts)
            )
        );
    }

    /**
     * Returns the highest of a series of monetary amounts.
     *
     * @param mixed $amount     a monetary amount
     * @param mixed ...$amounts additional monetary amounts
     */
    public function max(mixed $amount, mixed ...$amounts): string
    {
        return $this->convertToString(
            Money::max(
                $this->convertToM