 Exchange/SwapExchange.phpnu [         amount into a Money object, then into a string.
     *
     * @param mixed $amount typically a Money object, int, float, or string
     *                      representing a monetary amount
     *PK     g.s[ˋ    '  Exchange/IndirectExchangeQueuedItem.phpnu [        instanceof Money === false) {
            $amount = $this->convertToMoney($amount);
        }

        return $this->formatter->format($amount);
    }

    /**
     * Converts an array of monetary amounts into Money objects, then into
     * strings.
     *
     * @param array<int|string, mixed> $amounts an array of monetary amoPK     g.s[]S  S    Exchange/FixedExchange.phpnu [PK     g.s[-r  r    Exchange/SwapExchange.phpnu [        

        /** @var mixed $amount */
        foreach ($amounts as $key => $amount) {
            $converted[$key] = $this->convertToString($amount);
        }

        return $converted;
    }

    /**
     * Returns a "zero" monetary amount.
     */
    public function zero(): string
    {
        return '0.00';
    }
}
PK     g.s[]S  S    Exchange/FixedExchange.phpnu [PK     h.s[Sjtƨ      Exchange/IndirectExchange.phpnu [        ey\Currency;
use Money\CurrencyPair;
use Money\Exception\UnresolvableCurrencyPairException;
use Money\Exchange;

/**
 * Provides a way to get exchange rate from a static list (array).
 */
final class FixedExchange implements Exchange
{
    /** @psalm-var array<non-empty-string, array<non-empty-string, numeric-string>> */
    private array $list;

    /** @psalm-param array<non-empty-string, array<non-empty-string, numeric-string>> $list */
    public function __construct(array $list)
    {
        $this->list = $list;
    }

    public function quote(Currency $baseCurrency,PK     g.s[ˋ    '  Exchange/IndirectExchangeQueuedItem.phpnu [        ency->gePK     h.s[Sjtƨ      Exchange/IndirectExchange.phpnu [        (
                $baseCurrency,
                $counterCurrency,
                $this->list[$baseCurrency->getCode()][$counterCurrency->getCode()]
            );
        }

        throw UnresolvableCurrencyPairException::createFromCurrencies($baseCurrency, $counterCurrency);
    }
}
PK     g.s[ˋ  PK     g.s[-r  r    Exchange/SwapExchange.phpnu [        eclare(strict_types=1);

namespace Money\Exchange;

use Money\Currency;

/** @internal for sole consumption by {@see IndirectExchange} */
final class IndirectExchangeQueuedItem
{
    public Currency $currency;
    public bool $discovered = false;
    public ?self $parent    = null;

    public function __construct(Currency $currency)
    {
        $this->currency = $currency;
    }
}
PK     g.s[-r  r    Exchange/SwapExchange.phpnu [        <?php

declare(strict_types=1);

namespace Money\Exchange;

use Exchanger\Exception\Exception as ExchangerException;
use Money\Currency;
use Money\CurrencyPair;
use Money\Exception\UnresolvableCurrencyPairException;
use Money\Exchange;
use Swap\Swap;

use function assert;
use function is_numeric;
use function sprintf;

/**
 * Provides a way to get exchange rate from a third-party source and return a currency pair.
 */
final class SwapExchange implements Exchange
{
    private Swap $swap;

    public function __construct(Swap $swap)
    {
        $this->swap = $swap;
    }

    public function quote(Currency $baseCurrency, Currency $counterCurrency): CurrencyPair
    {
 PK     h.s[Sjtƨ      Exchange/IndirectExchange.phpnu [         . '/' . $counterCurrency->getCode());
        } catch (ExchangerException) {
            throw UnresolvableCurrencyPairException::createFromCurrencies($baseCurrency, $counterCurrency);
        }

        $rateValue = sprintf('%.14F', $rate->getValue());

        assert(is_numeric($rateValue));

        return new CurrencyPair($baseCurrency, $counterCurrency, $rateValue);
    }
}
PK     h.s[Sjtƨ      Exchange/IndirectExchange.phpnu [        <?php

declare(strict_types=1);

namespace Money\Exchange;

use Money\Currencies;
use Money\Currency;
use Money\CurrencyPair;
use Money\Exception\UnresolvableCurrencyPairException;
use Money\Exc