verse;

/**
 * Provides a way to get an exchange rate through a minimal set of intermediate conversions.
 */
final class IndirectExchange implements Exchange
{
    private Currencies $currencies;

    private Exchange $exchange;

    public function __construct(Exchange $exchange, Currencies $currencies)
    {
        $this->exchange   = $exchange;
        $this->currencies = $currencies;
    }

    public function quote(Currency $baseCurrency, Currency $counterCurrency): CurrencyPair
    {
        try {
            return $this->exchange->quote($baseCurrency, $counterCurrency);
        } catch (UnresolvableCurrencyPairException) {
            $rate = array_reduce(
                $this->getConversions($baseCurrency, $counterCurrency),
                /**
                 * @psalm-param numeric-string $carry
                 *
                 * @psalm-return numeric-string
                 */
                static function (string $carry, CurrencyPair $pair) {
                    $calculator = Money::getCalculator();

                    return $calculator::multiply($carry, $pair->getConversionRatio());
                },
                '1.0'
         PK     h.s[d~    '  Exchange/ReversedCurrenciesExchange.phpnu [             }
    }

    /**
     * @return CurrencyPa