ublic function setEntityId(string $id): self
    {
        $this->entityId = $id;
        return $this;
    }

    public function getWarningMessage(): ?string
    {
        if ($this->getType() === 'text' && ! self::isGsm7($this->getMessage())) {
            $this->setWarningMessage("You are sending a message as `text` which contains non-GSM7 
            characters. This could result in encoding problems with the target device - See 
            https://developer.vonage.com/messaging/sms for details, or email support@vonage.com if you have any 
            questions.");
        }

        return $this->warningMessage;
    }

    /**
     * @return array<mixed>
     */
    public function toArray(): array
    {
        $data = ['text' => $this->getMessage()];
        if (!empty($this->entityId)) {
            $data['entity-id'] = $this->entityId;PK     @Fs[k?        Faker/Extension/Extension.phpnu [        t-id'] = $this->contentId;
        }

        $data = $this->appendUniversalOptions($data);

        return $data;
    }

    public function getMessage(): string
    {
        return $this->message;
    }

    public function enableDLT(string $entitPK     @Fs[ARJ       Faker/Extension/Helper.phpnu [                $this->contentId = $templateId;

        return $this;
    }
}
PK     t[[m      SMS/Message/Message.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\SMS\Message;

interface Message
{
    public function toArray(): array;
    public function getErrorMessage(): ?string;
    public function getWarningMessage(): ?string;
    public function setWarningMessage(?string $errorMessage): void;
}
PK     t[ĥg  g    SMS/Message/OutboundMessage.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\SMS\Message;

use InvalidArgumentException;

use function array_merge;
use function is_null;
use function strlen;

abstract class OutboundMessage implements Message
{
    protected ?string $accountRef = null;

    protected ?string $clientRef = null;

    protected ?string $deliveryReceiptCallback = null;

    protected ?int $messageClass = null;

    protected bool $requestDeliveryReceipt = true;

    /**
     * TTL of the SMS delivery, in milliseconds
     *
     * @var int
     */
    protected $ttl = 259200000;

    protected ?string $warningMessage = null;

    /**
     * Type of message, set by the child class
     *
     * @var string
     */
    protected string $type;

    public function __construct(protected string $to, protected string $from)
    {
    }

    /**
     * @deprecated Shim when correcting naming conventions, will be removed when it comes out the interface
     */
    public function getErrorMessage(): ?string
    {
        