age\Client\Exception as ClientException;
use Vonage\Client\Exception\ThrottleException;

use function json_decode;
use function preg_match;

class ExceptionErrorHandler
{
    /**
     * @throws ClientException\Request
     * @throws ClientException\Server
     * @throws ThrottleException
     */
    public function __invoke(ResponseInterface $response, RequestInterface $request)
    {
        //check for valid data, as well as an error response from the API
        if ((int)$response->getStatusCode() === 429) {
            throw new ThrottleException('Too many concurrent requests', $response->getStatusCode());
        }