, $max);
    }

    /**
     * @example '86.211205'
     *
     * @return  function semver(bool $preRelease = false, bool $build = false): string
    {
        return sprintf(
            '%d.%d.%d%s%s',
            mt_rand(0, 9),
            mt_rand(0, 99),
            mt_rand(0, 99),
            $preRelease && mt_rand(0, 1) ? '-' . $this->semverPreReleaseIdentifier() : '',
            $build && mt_rand(0, 1) ? '+' . $this->semverBuildIdentifier() : '',
        );
    }

    /**
     * Common pre-release identifier
     */
    private function semverPreReleaseIdentifier(): string
    {
        $ident = Helper::randomElement($this->semverCommonPreReleaseIdentifiers);

        if (!mt_rand(0, 1)) {
            return $ident;
        }

        return $ident . '.' . mt_rand(1, 99);
    }

    /**
     * Common random build identifier
     */
    private function semverBuildIdentifier(): string
    {
        if (mt_rand(0, 1)) {
            // short git revision syntax: https://git-scm.com/book/en/v2/Git-Tools-Revision-Selection
            return substr(sha1(Helper::lexify('??????')), 0, 7);
        }

        // date syntax
        return DateTime::date('YmdHis');
    }
}
PK     Fs[(T      Faker/Guesser/Name.phpnu [        <?php

namespace Faker\Guesser;

use Faker\Provider\Base;

class Name
{
    protected $generator;

    public function __construct(\Faker\Generator $generator)
    {
        $this->generator = $generator;
    }

    /**
     * @param string   $name
     * @param int|null $size Length of field, if known
     *
     * @return callable|null
     */
    public function guessFormat($name, $size = null)
    {
        $name = Base::toLower($name);
        $generator = $this->generator;

        if (preg_match('/^is[_A-Z]/', $name)) {
            return static function () use ($generator) {
                return $generator->boolean;
            };
        }

        if (preg_match('/(_a|A)t$/', $name)) {
            return static function () use ($generator) {
                return $generator->dateTime;
            };
        }

        switch (str_replace('_', '', $name)) {
            case 'firstname':
                return static function () use ($generator) {
                    return $generator->firstName;
                };

            case 'lastname':
                return static function () use ($generator) {
                    return $generator->lastName;
                };

            case 'username':
            case 'login':
                return static function () use ($generator) {
                    return $generator->userName;
                };

            case 'email':
            case 'emailaddress':
                return static function () use ($generator) {
                    return $generator->email;
                };

            case 'phonenumber':
            case 'phone':
            case 'telephone':
            case 'telnumber':
                return static function () use ($generator) {
                    return $generator->phoneNumber;
                };

            case 'address':
                return static function () use ($generator) {
                    return $generator->address;
                };

            case 'city':
            case 'town':
                return static function () use ($generator) {
                    return $generator->city;
                };

            case 'streetaddress':
                return static function () use ($generator) {
                    return $generator->streetAddress;
                };

            case 'postcode':
            case 'zipcode':
                return static function () use ($generator) {
                    return $generator->postcode;
                };

            case 'state':
                return static function () use ($generator) {
                    return $generator->state;
                };

            case 'county':
                if ($this->generator->locale == 'en_US') {
                    return static function () use ($generator) {
                        return sprintf('%s County', $generator->city);
                    };
                }

                return static function () use ($generator) {
                    return $generator->state;
                };

            case 'country':
                switch ($size) {
                    case 2:
                        return static function () use ($generator) {
                            return $generator->countryCode;
                        };

                    case 3:
                        return static function () use ($generator) {
                            return $generator->countryISOAlpha3;
                        };

                    case 5:
                    case 6:
                        return static function () use ($generator) {
                            return $generator->locale;
                        };

                    default:
                        return static function () use ($generator) {
                            return $generator->country;
                        };
                }

                break;

            case 'locale':
                return static function () use ($generator) {
                    return $generator->loc