 public function getResponse();

    public function getResponseData();

    public function setResponse(ResponseInterface $response);

    public function setRequest(RequestInterface $request);
}
PK     t[oP.  .     Entity/JsonSerializableTrait.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Entity;

use JsonSerializable;
use Vonage\Client\Exception\Exception as ClientException;

use function sprintf;

/**
 * Implements getRequestData from EntityInterface based on the entity's jsonSerialize().
 *
 * @see EntityInterface::getRequestData()
 * @deprecated Each model will handle serializing to/from JSON via hydrators
 */
trait JsonSerializableTrait
{
    /**
     * Get an array of params to use in an API request.
     *
     * @param bool $sent
     *
     * @throws ClientException
     */
    public function getRequestData($sent = true)
    {
        if (!($this instanceof EntityInterface)) {
            throw nePK     <Fs[si    &  Faker/ORM/Doctrine/EntityPopulator.phpnu [        f the class implements %s',
                    __TRAIT__,
                    EntityInterface::class
                )
            );
        }

        if (!($this instanceof JsonSerializable)) {
            throw new ClientException(
                sprintf(
                    '%s can only be used if the class implements %s',
                    __TRAIT__,
                    JsonSerializable::class
                )
            );
        }

        //TODO, figure out what the request data actually was
        $sent && $this->getRequest();

        return $this->jsonSerialize();
    }
}
PK     t[ZO      Secrets/ClientFactory.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Secrets;

use Vonage\Client\APIResource;
use Vonage\Client\Credentials\Basic;
use Vonage\Client\Credentials\Handler\BasicHandler;
use Vonage\Client\Factory\FactoryInterface;

class ClientFactory
{
    public function __invoke(FactoryInterface $container): Client
    {
        $api = $container->make(APIResource::class);
        $api->setBaseUri('/accounts')
            ->setAuthHandler(new BasicHandler())
            ->setCollectionName('secrets');

        return new Client($api);
    }
}
PK     t[>      Secrets/Client.phpnu [        <?php

namespace Vonage\Secrets;

use Vonage\Client\APIClient;
use Vonage\Client\APIResource;
use Vonage\Entity\Hydrator\ArrayHydrator;
use Vonage\Entity\IterableAPICollection;

class Client implements APIClient
{
    public function __construct(protected APIResource $api)
    {
    }

    public function getAPIResource(): APIResource
    {
        return $this->api;
    }

    public function get(string $accountId, string $id): Secret
    {
        $data = $this->api->get("{$accountId}/secrets/{$id}");

        return new Secret($data);
    }

    public function list(string $accountId): IterableAPICollection
    {
        $collection = $this->api->search(null, "/accounts/{$accountId}/secrets");
        $hydrator = new ArrayHydrator();
        $hydrator->setPrototype(new Secret());
        $collection->setHydrator($hydrator);

        return $collection;
    }

    public function create(string $accountId, string $secret): Secret
    {
        $response = $this->api->create(['secret' => $secret], "/{$accountId}/secrets");
        return new Secret($response);
    }

    public function revoke(string $accountId, string $id)
    {
        $this->api->delete("{$accountId}/secrets/{$id}");
    }
}
PK     t[KK      Secrets/Secret.phpnu [        <?php

namespace Vonage\Secrets;

use DateTimeImmutable;
use DateTimeInterface;
use Vonage\Entity\Hydrator\ArrayHydrateInterface;

class Secret implements ArrayHydrateInterface
{
    /**
     * @var DateTimeImmutable
     */
    protected $createdAt;

    /**
     * @var string
     */
    protected $id;

    public function __construct(array $data = [])
    {
        if (!empty($data)) {
            $this->fromArray($data);
        }
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getCreatedAt(): DateTimeInterface
    {
        return $this->createdAt;
    }

    public function fromArray(array $data)
    {
        $this->id = $data['id'];
        $this->createdAt = new DateTimeImmutable($data['created_at']);
    }

    public function toArray(): array
    {
        return [
            'id' => $this->id,
            'created_at' => $this->createdAt->format('Y-m-d\TH:i:s\Z'),
        ];
    }
}
PK     t[%Q  Q    Insights/StandardCnam.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Insights;

class StandardCnam extends Standard
{
    use CnamTrait;
}
PK     t[ܠ      Insights/ClientFactory.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Insights;

use Psr\Container\ContainerInterface;
use Vonage\Client\APIResource;
use Vonage\Client\Credentials\Handler\BasicQueryHandler;

class ClientFactory
{
    public function __invoke(ContainerInterface $container): Client
    {
        /** @var APIResource $api */
        $api = $container->make(APIResource::class);
        $api->setIsHAL(false);
        $api->setAuthHandler(new BasicQueryHandler());

        return new Client($api);
    }
}
PK     t[%J      Insights/Client.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Insights;

use Psr\Http\Client\ClientExceptionInterface;
use Vonage\Client\APIClient;
use Vonage\Client\APIResource;
use Vonage\Client\ClientAwareInterface;
use Vonage\Client\ClientAwareTrait;
use Vonage\Client\Exception as ClientException;
use Vonage\Entity\Filter\KeyValueFilter;
use Vonage\Numbers\Number;

use function is_null;

/**
 * Class Client
 */
class Client implements APIClient
{
    public function __construct(protected ?APIResource $api = null)
    {
    }

    public function getApiResource(): APIResource
    {
        return clone $this->api;
    }

    /**
     * @param $number
     *
     * @throws ClientExceptionInterface
     * @throws ClientException\Exception
     * @throws ClientException\Request
     * @throws ClientException\Server
     */
    public function basic($number): Basic
    {
        $ins