inconsistent API behaviours
     */
    protected bool $noIndex = false;

    /**
     * Used if there are HAL elements, but entities are all in one request
     * Specifically removes automatic pagination that adds request parameters
     */
    protected bool $noQueryParameters = false;

    /**
     * User set pgge size.
     */
    protected ?int $size = null;

    protected ?FilterInterface $filter = null;

    protected string $collectionName = '';

    protected string $collectionPath = '';

    protected $hydrator;

    /**
     * Used to override pagination to remove it from the URL page query
     * but differs from noQueryParameters when you want to use other filters
     */
    protected bool $hasPagination = true;

    public function getPageIndexKey(): string
    {
        return $this->pageIndexKey;
    }

    public function setPageIndexKey(string $pageIndexKey): IterableAPICollection
    {
        $this->pageIndexKey = $pageIndexKey;

        return $this;
    }

    public function getPageSizeKey(): string
    {
        return $this->pageSizeKey;
    }

    public function setPageSizeKey(string $pageSizeKey): IterableAPICollection
    {
 PK     <Fs[)Wa
  
  &  Faker/ORM/Propel/ColumnTypeGuesser.phpnu [         @param $hydrator
     *
     * @return $this
     */
    public function setHydrator($hydrator): self
    {
        $this->hydrator = $hydrator;
        return $this;
    }

    /**
     * @param $data
     * @param $id deprecated
     */
    public function hydrateEntity($data, $id = null)
    {
        if ($this->hydrator) {
            return $this->hydrator->hydrate($data);
        }

        return $data;
    }

    public function getResourceRoot(): array
    {
        // Handles issues where an API returns empty for no results, as opposed
        // to a proper API response with a count field of 0
        if (empty($this->pageData)) {
            return [];
        }

        $collectionName = $this->getApiResource()->getCollectionName();

        if ($this->getApiResource()->isHAL()) {
            return $this->pageData['_embedded'][$collectionName];
        }

        if (!empty($this->getApiResource()->getCollectionName())) {
            return $this->pageData[$collectionName];
        }

        return $this->pageData;
    }

    /**
     * Return the current item, expects concrete collection to handle creating the object.
     *
     * @throws ClientExceptionInterface
     * @throws ClientException\Exception
     * @throws ClientException\Request
     * @throws ClientException\Server
     */
    #[\ReturnTypeWillChange]
    public function current()
    {
        if (is_null($this->current)) {
            $this->rewind();
        }

        return $this->hydrateEntity($this->getResourceRoot()[$this->current], $this->key());
    }

    /**
     * No checks here, just advance the index.
     */
    public function next(): void
    {
        $this->current++;
    }

    /**
     * Return the ID of the resource, in some cases this is `id`, in others `uuid`.
     *
     * @return string
     */
    #[\ReturnTypeWillChange]
    public function key()
    {
        return
            $this->getResourceRoot()[$this->current]['id'] ??
            $this->getResourceRoot()[$this->current]['uuid'] ??
            $this->current;
    }

    /**
     * Handle pagination automatically (unless configured not to).
     *
     * @throws ClientExceptionInterface
     * @throws ClientException\Exception
     * @throws ClientException\Request
