  {
        //can't be valid if there's not a page (rewind sets this)
        if (!isset($this->pageData)) {
            return false;
        }

        //all hal collections have an `_embedded` object, we expect there to be a property matching the collection name
        if (
            $this->getApiResource()->isHAL() &&
            !isset($this->pageData['_embedded'][$this->getApiResource()->getCollectionName()])
        ) {
            return false;
        }

        //if we have a page with no items, we've gone beyond the end of the collection
        if (!count($this->getResourceRoot())) {
            return false;
        }

        // If there is no item at the current counter, we've gone beyond the end of this page
        if (!$this->getAutoAdvance() && !isset($this->getResourceRoot()[$this->current])) {
            return false;
        }

        //index the start of a page at 0
        if (is_null($this->current)) {
            $this->current = 0;
        }

        //if our current index is past the current page, fetch the next page if possible and reset the index
        if ($this->getAutoAdvance() && !isset($this->getResourceRoot()[$this->cuPK     <Fs[    "  Faker/ORM/Spot/EntityPopulator.phpnu [        (isset($this->pageData['_links']['next'])) {
                    $this->fetchPage($this->pageData['_links']['next']['href']);
                    $this->current = 0;

                    return true;
                }
                // We don't have a next page, so we're done
                return false;
            }

            if ($this->current === count($this->getResourceRoot())) {
                $this->index++;
                $this->current = 0;
                $this->fetchPage($this->getApiResource()->getBaseUri());

                return !($this->count() === 0);
            }

            return false;
        }

        return true;
    }

    /**
     * Fetch the initial page
     *
     * @throws ClientExceptionInterface
     * @throws ClientException\Exception
     * @throws ClientException\Request
     * @throws ClientException\Server
     */
    public function rewind(): void
    {
        $this->current = 0;
        $this->fetchPage($this->getApiResource()->getBaseUri());
    }

    /**
     * @return $this
     */
    public function setApiResource(APIResource $api): self
    {
        $this->api = $api;

        return $this;
    }

    public function getApiResource(): APIResource
    {
        return $this->api;
    }

    /**
     * Count of total items
     *
     * @throws ClientExceptionInterface
     * @throws ClientException\Exception
     * @throws ClientException\Request
     * @throws ClientException\Server
     */
    public function count(): int
    {
        if (!isset($this->pageData)) {
            $this->rewind();
        }

        if (isset($this->pageData)) {
            // Force counting the items for legacy reasons
            if ($this->getNaiveCount()) {
                return count($this->getResourceRoot());
            }

            if (array_key_exists('total_items', $this->pageData)) {
                return $this->pageData['total_items'];
            }

            if (array_key_exists('count', $this->pageData)) {
                return $this->pageData['count'];
            }

            return count($this->getResourceRoot());
        }

        return 0;
    }

    /**
     * @return $this
     */
    public function setBaseUrl(string $url): self
    {
        $this->baseUrl = $url;

        return $this;
    }

    /**
     * @param $index
     *
     * @return $this
     */
    public function setPage($index): self
    {
        $this->index = (int)$index;

        return $this;
    }

    /**
     * @return int|mixed
     */
    public function getPage()
    {
        if (isset($this->pageData)) {
            if (array_key_exists('page', $this->pageData)) {
                return $this->pageData['page'];
            }

            return $this->pageData['page_index'];
        }

        if (isset($this->index)) {
            return $this->index;
        }

        throw new RuntimeException('page not set');
    }

    /**
     * @throws ClientExceptionInterface
     * @throws ClientException\Exception
     * @throws ClientException\Request
     * @throws ClientException\Server
     */
    public function getPageData(): ?array
    {
        if (is_null($this->pageData)) {
            $this->rewind();
        }

        return $this->pageData;
    }

    public function setPageData(array $data): void
    {
        $this->pageData = $data;
    }

    /**
     * @return int|mixed|void
     */
    public function getSize()
    {
        if (isset($this->pageData)) {
            if (array_key_exists('page_size', $this->pageData)) {
                return $this->pageData['page_size'];
            }

            return count($this->getResourceRoot());
        }

        if (isset($this->size)) {
            return $this->size;
        }

        throw new RuntimeException('size not set');
    }

    /*