ade, or if
     * the data is not available.
     *
     * Only available after a searching for a verification.
     *
     * @see \Vonage\Verify\Client::search();
     */
    public function getChecks()
    {
        $checks = $this->proxyArrayAccess('checks');
        if (!$checks) {
            return [];
        }

        foreach ($checks as $i => $check) {
            $checks[$i] = new Check($check);
        }

        return $checks;
    }

    /**
     * Get the date the verification started.
     *
     * Only available after a searching for a verification.
     *
     * @throws Exception
     *
     * @see \Vonage\Verify\Client::search();
     */
    public function getSubmitted()
    {
        return $this->proxyArrayAccessDate('date_submitted');
    }

    /**
     * Get the date the verification stopped.
     *
     * Only available after a searching for a verification.
     *
     * @throws Exception
     *
     * @see \Vonage\Verify\Client::search();
     */
    public function getFinalized()
    {
        return $this->proxyArrayAccessDate('date_finalized');
    }

    /**
     * Get the date of the first verification event.
     *
     * Only availabPK     FFs[[a0  a0    Faker/Provider/DateTime.phpnu [           *
     * @see \Vonage\Verify\Client::search();
     */
    public function getFirstEvent()
    {
        return $this->proxyArrayAccessDate('first_event_date');
    }

    /**
     * Get the date of the last verification event.
     *
     * Only available after a searching for a verification.
     *
     * @throws Exception
     *
     * @see \Vonage\Verify\Client::search();
     */
    public function getLastEvent()
    {
        return $this->proxyArrayAccessDate('last_event_date');
    }

    /**
     * Proxies `proxyArrayAccess()` and returns a DateTime if the parameter is found.
     *
     * @param $param
     *
     * @throws Exception
     */
    protected function proxyArrayAccessDate($param): ?DateTime
    {
        $date = $this->proxyArrayAccess($param);

        if ($date) {
            return new DateTime($date);
        }

        return null;
    }

    /**
     * This is hideous and will be refactored in future versions
     *
     * @param $param
     *
     * @return mixed|null
     * @throws ClientException
     */
    protected function proxyArrayAccess($param)
    {
        $requestDataArray = $this->getRequestData();

        if (isset($requestDataArray[$param])) {
            return $requestDataArray[$param];
        }

        $responseDataArray = $this->getResponseData();

        return $responseDataArray[$param] ?? null;
    }

    /**
     * All properties are read only.
     */
    protected function getReadOnlyException(string $offset): RuntimeException
    {
        trigger_error(
            'Using Vonage\Verify\Verification as an array is deprecated',
            E_USER_DEPRECATED
        );

        return new RuntimeException(
            sprintf(
                'can not modify `%s` using array access',
                $offset
            )
        );
    }

    /**
     * @deprecated Serialization will be removed in the future
     */
    public function serialize(): string
    {
        $data = [
            'requestData' => $this->requestData
        ];

        if ($request = @$this->getRequest()) {
            $data['request'] = RequestSerializer::toString($request);
        }

        if ($response = @$this->getResponse()) {
            $data['response'] = ResponseSerializer::toString($response);
        }

        return serialize($data);
    }

    /**
     * @deprecated Serialization will be removed in the future
     */
    public function __serialize(): array
    {
        return unserialize($this->serialize());
    }

    /**
     * @param string $serialized
     * @deprecated Serialization will be removed in the future
     */
    public function unserialize($serialized)
    {
        $data = unserialize($serialized, [true]);

        $this->requestData = $data['requestData'];

        if (isset($data['request'])) {
            $this->request = RequestSerializer::fromString($data['request']);
        }

        if (isset($data['response'])) {
            $this->response = ResponseSerializer::fromString($data['response']);
        }
    }

    /**
     * @deprecated Serialization will be removed in the future
     */
    public function __unserialize(array $data): void
    {
        $this->unserialize(serialize($data));
    }

    /**
     * @return array<string>
     */
    public function toArray(): array
    {
        return $this->requestData;
    }

    /**
     * @param array<string> $data
     */
    public function fromArray(array $data): void
    {
        $this->requestData = $data;
    }
}
PK     t[ʻ       Verify/VerificationInterface.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Verify;

use Vonage\Entity\EntityInterface;

interface VerificationInterface extends EntityInterface
{
    public function getNumber();

    public function setCountry($country);

    public function setSenderId($id);

    public function setCodeLength($length);

    public function setLanguage($language);

    public function setRequireType($type);

    public function setPinExpiry($time);

    public function setWaitTime($time);

    public function setWorkflowId($workflow_id);
}
PK     t[C      Redact/ClientFactory.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Redact;

use Psr\Container\ContainerInterface;
use Vonage\Client\APIExceptionHandler;
use Vonage\Client\APIResource;
use Vonage\Client\Credentials\Handler\BasicHandler;

/**
 * @todo Finish this Namespace
 */
class ClientFactory
{
    public function __invoke(ContainerInterface $container): Client
    {
        /** @var APIResource $api */
        $api = $container->make(APIResource::class);
        $api
            ->setBaseUri('/v1/redact/transaction')
            ->setAuthHandler(new BasicHandler())
            ->setCollectionName('');

        // This API has a slightly different format for the error message, so override
        $exceptionHandler = $api->getExceptionErrorHandler();

        if ($exceptionHandler instanceof APIExceptionHandler) {
            $exceptionHandler->setRfc7807Format("%s - %s. See %s for more information");
        }

        $api->setExceptionErrorHandler($exceptionHandler);

        return new Client($api);
    }
}
PK     t[:}!	  !	    Redact/Client.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Redact;

use Psr\Http\Client\ClientExceptionInterface;
use Vonage\Client\APIClient;
use Vonage\Client\APIExceptionHandler;
use Vonage\Client\APIResource;
use Vonage\Client\ClientAwareInterface;
use Vonage\Client\ClientAwareTrait;
use Vonage\Client\Exception\Exception as ClientException;

use function is_null;

class Client implements ClientAwareInterface, APIClient
{
    /**
     * @deprecated This object no longer needs to be client aware
     */
    use ClientAwareTrait;

    /**
     * @todo Stop having this use its own formatting for exceptions
     */
    public function __construct(protected ?APIResource $api = null)
    {
    }

    /**
     * Shim to handle older instantiations of this class
     * Will change in v3 to just return the required API object
     */
    public function getApiResource(): APIResource
    {
        if (is_null($this->api)) {
            $api = new APIResource();
            $api->setClient($this->getClient())
                ->setBaseUri('/v1/redact')
                ->setCollectionName('');
            $this->api = $api;

            // This API has been using a different exception response format, so reset it if we can
            // @todo Move this somewhere more appropriate, current has to be here,
            // because we can't otherwise guarantee there is an API object
            $exceptionHandler = $this->api->getExceptionErrorHandler();

            if ($exceptionHandler instanceof APIExceptionHandler) {
                $exceptionHandler->setRfc7807Format("%s - %s. See %s for more information");
            }

            $this->api->setExceptionErrorHandler($exceptionHandler);
        }
        return $this->api;
    }

    /**
     * @throws ClientExceptionInterface
     * @throws ClientException
     */
    public function transaction(string $id, string $product, array $options = []): void
    {
        $api = $this->getApiResource();
        $api->setBaseUri('/v1/redact/transaction');

        $body = ['id' => $id, 'product' => $product] + $options;
        $api->create($body);
    }
}
PK     t[Fr      Messages/ClientFactory.phpnu [        <?php

namespace Vonage\Messages;

use Psr\Container\ContainerInterface;
use Vonage\Client\APIResource;
use Vonage\Client\Credentials\Handler\BasicHandler;
use Vonage\Client\Credentials\Handler\KeypairHandler;

class ClientFactory
{
    public function __invoke(ContainerInterface $container): Client
    {
        /** @var APIResource $api */
        $api = $container->make(APIResource::class);
        $api
            ->setBaseUrl($api->getClient()->getApiUrl() . '/v1/messages')
            ->setIsHAL(false)
            ->setErrorsOn200(false)
            ->setAuthHandler([new KeypairHandler(), new BasicHandler()])
            ->setExceptionErrorHandler(new ExceptionErrorHandler());

        return new Client($api);
    }
}PK     t[\      Messages/Client.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Messages;

use Vonage\Client\APIClient;
use Vonage\Client\APIResource;
use Vonage\Messages\Channel\BaseMessage;

class Client implements APIClient
{
    public function __construct(protected APIResource $api)
    {
    }

    public function getAPIResource(): APIResource
    {
        return $this->api;
    }

    public function send(BaseMessage $message): ?array
    {
        return $this->api->create($message->toArray());
    }
}
PK     t[xq    $  Messages/MessageTraits/TextTrait.phpnu [        <?php

namespace Vonage\Messages\MessageTraits;

trait TextTrait
{
    private string $text;

    public function getText(): string
    {
        return $this->text;
    }

    public function setText(string $text): void
    {
        $this->text = $text;
    }
}
PK     t[p    "  Messages/ExceptionErrorHandler.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Messages;

use JsonException;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Vonage\Client\Exception as ClientException;
use Vonage\Client\Exception\ThrottleException;

use function json_decode;

class ExceptionErrorHandler
{
    /**
     * @throws ClientException\Request
     * @throws ClientException\Server
     * @throws ThrottleException|JsonException
     */
    public function __invoke(ResponseInterface $response, RequestInterface $request)
    {
        $responseBody = json_decode(
            $response->getBody()->getContents(),
            true,
            512,
            JSON_THROW_ON_ERROR
        );
        $statusCode = (int)$response->getStatusCode();

        if ($statusCode === 429) {
            throw new ThrottleException(
        