
        $partialValue = static::numerify(str_repeat('#', 9));

        return Luhn::generateLuhnNumber($partialValue);
    }

    /**
     * example 010101
     */
    public static function companyTradeRegisterNumber()
    {
        $partialValue = static::numerify(str_repeat('#', 6));

        return Luhn::generateLuhnNumber($partialValue);
    }
}
PK     XFs[]\D  D     Faker/Provider/ar_EG/Payment.phpnu [        <?php

namespace Faker\Provider\ar_EG;

class Payment extends \Faker\Provider\Payment
{
    /**
     * International Bank Account Number (IBAN)
     *
     * @see https://www.upiqrcode.com/iban-generator/eg/egypt
     */
    public function bankAccountNumber(): string
    {
        return self::iban('EG', '', 25);
    }
}
PK     XFs[W    !  Faker/Provider/ar_EG/Internet.phpnu [        <?php

namespace Faker\Provider\ar_EG;

class Internet extends \Faker\Provider\Internet
{
    protected static $userNameFormats = [
        '{{lastNameAscii}}.{{firstNameAscii}}',
        '{{firstNameAscii}}.{{lastNameAscii}}',
        '{{firstNameAscii}}##',
        '?{{lastNameAscii}}',
    ];
    protected static $safeEmailTld = [
     PK     XFs[.b'  '     Faker/Provider/ar_EG/Address.phpnu [        = [
        'biz', 'com', 'come.eg', 'info', 'eg', 'net', 'org',
    ];

    protected static $lastNameAscii = [
        'ahmed',
        'mostafa',
        'mahmoud',
        'carmen',
        'rakeen',
        'hazem',
        'ezz',
        'hemeida',
        'ramah',
        'fahmy',
        'ehab',
        'karim',
        'abdulaziz',
        'elsherbiny',
        'karam',
        'abdulaziz',
        'bayoumi',
        'tharwat',
        'elshamy',
        'youssef',
        'rizk',
        'ramzy',
        'younes',
        'selim',
    ];
    protected static $firstNameAscii = [
        'ahmed',
        'mostafa',
        'mahmoud',
        'hazem',
        'ehab',
        'karim',
        'dina',
        'maged',
        'mohamed',
        'saif',
        'basma',
        'youssef',
        'hashem',
        'dina',
        'hani',
        'hashem',
    ];

    public static function lastNameAscii()
    {
        return static::randomElement(static::$lastNameAscii);
    }

    public static function firstNameAscii()
    {
        return static::randomElement(static::$firstNameAscii);
    }

    /**
     * @example 'ahmad.abbadi'
     */
    public function userName()
    {
        $format = static::randomElement(static::$userNameFormats);

        return static::bothify($this->generator->parse($format));
    }

    /**
     * @example 'wewebit.jo'
     */
    public function domainName()
    {
        return static::randomElement(static::$lastNameAscii) . '.' . $this->tld();
    }
}
PK     XFs[.b'  '     Faker/Provider/ar_EG/Address.phpnu [        <?php

namespace Faker\Provider\ar_EG;

class Address extends \Faker\Provider\Address
{
    protected static $cityPrefix = [
        'شمال',
        'جنوب',
        'شرق',
        'غرب',
    ];

    protected static $streetPrefix = ['شارع', 'طريق', 'ممر'];

    /**
     * @see https://ar.wikipedia.org/wiki/%D8%AA%D8%B5%D9%86%D9%8A%D9%81:%D8%A3%D8%AD%D9%8A%D8%A7%D8%A1_%D8%A7%D9%84%D9%82%D8%A7%D9%87%D8%B1%D8%A9
     */
    protected static $cityName = [
        'التجمع الاول',
        'التجمع التالت',
        'التجمع الخامس',
        'الشروق',
        'الرحاب',
        'الجزيرة',
        'الحسين',
        'الزمالك',
        'السلام',
        'الظاهر',
        'العباسية',
        'المطرية',
        'الموسكي',
        'النزهة الجديدة',
        'السيدة زينب',
        'المرج',
        'المعادي',
        'المقطم',
        'المنيل',
        'الوايلي',
        'باب الشعرية',
        'باب اللوق',
        'ثكنات المعادي',
        'جاردن سيتي',
        'جسر السويس',
        'عابدين',
        'حدائق المعادي',
        'حلمية الزيتون',
        'حلوان',
        'الأزبكية',
        'الزاوية الحمراء',
        'الساحل',
        'مدينة نصر',
        'حدائق القبة',
        'شبرا',
        'عين شمس',
        'روكسي',
        'زهراء المعادي',
        'سراي القبة',
        'عبود',
        'عزبة النخل',
        'كوتسيكا',
        'الشيخ زايد',
        'السادس من اكتوير',
        'العاشر من رمضان',
        'المعصرة',
        'الزهراء',
        'غمرة',
        'المنيب',
        'فيصل',
        'الدقي',
        'العتبة',
        'المظلات',
        'المطار',
        'قباء',
        'ألف مسكن',
        'هليوبوليس',
        'هارون',
        'كلية البنات',
        'عبده باشا',
        'الجيش',
        'الكيت كات',
        'إمبابة',
    ];

    /**
     * @see https://ar.wikipedia.org/wiki/%D9%82%D8%A7%D8%A6%D9%85%D8%A9_%D9%85%D8%AD%D8%A7%D9%81%D8%B8%D8%A7%D8%AA_%D9%85%D8%B5%D8%B1
     * @see https://ar.wikipedia.org/wiki/%D8%A8%D8%B7%D8%A7%D9%82%D8%A9_%D8%A7%D9%84%D8%B1%D9%82%D9%85_%D8%A7%D9%84%D9%82%D9%88%D9%85%D9%8A_%D8%A7%D9%84%D9%85%D8%B5%D8%B1%D9%8A%D8%A9
     */
    protected static $governorates = [
        'الإسكندرية' => '02',
        'الإسماعيلية' => '19',
        'أسوان' => '28',
        'أسيوط' => '25',
        'الأقصر' => '29',
        'البحر الأحمر' => '31',
        'البحيرة' => '18',
        'بني سويف' => '22',
        'بورسعيد' => '03',
        'جنوب سيناء' => '35',
        'القاهرة' => '01',
        'الدقهلية' => '12',
        'دمياط' => '11',
        'سوهاج' => '26',
        'السويس' => '04',
        'الشرقية' => '13',
        'شمال سيناء' => '34',
        'الغربية' => '16',
        'الفيوم' => '23',
        'القليوبية' => '14',
        'قنا' => '27',
        'كفر الشيخ' => '15',
        'مطروح' => '33',
        'المنوفية' => '17',
        'المنيا' => '24',
        'الوادي الجديد' => '32',
    ];

    protected static $buildingNumber = ['%####', '%###', '%#'];

    protected static $postcode = ['#####', '#####-####'];

    /**
     * @see http://www.nationsonline.org/oneworld/countrynames_arabic.htm
     */
    protected static $country = [
        'الكاريبي', 'أمريكا الوسطى', 'أنتيجوا وبربودا', 'أنجولا', 'أنجويلا', 'أندورا', 'اندونيسيا', 'أورجواي', 'أوروبا', 'أوزبكستان', 'أوغندا', 'أوقيانوسيا', 'أوقيانوسيا النائية', 'أوكرانيا', 'ايران', 'أيرلندا', 'أيسلندا', 'ايطاليا',
        'بابوا غينيا الجديدة', 'باراجواي', 'باكستان', 'بالاو', 'بتسوانا', 'بتكايرن', 'بربادوس', 'برمودا', 'بروناي', 'بلجيكا', 'بلغاريا', 'بليز', 'وام', 'جورجيا', 'جورجيا الجنوبية وجزر ساندويتش الجنوبية', 'جيبوتي', 'جيرسي',
        'دومينيكا',
        'رواندا', 'روسيا', 'روسيا البيضاء', 'رومانيا', 'روينيون',
        'زامبيا', 'زيمبابوي',
        'ساحل العاج', 'ساموا', 'ساموا الأمريكية', 'سانت بيير وميكولون', 'سانت فنسنت وغرنادين', 'سانت كيتس ونيفيس', 'سانت لوسيا', 'سانت مارتين', 'سانت هيلنا', 'سان مارينو', 'ساو تومي وبرينسيبي', 'سريلانكا', 'سفالبارد وجان مايان', 'سلوفاكيا', 'سلوفينيا', 'سنغافورة', 'سوازيلاند', 'سوريا', 'سورينام', 'سويسرا', 'سيراليون', 'سيشل',
        'شرق آسيا', 'شرق افريقيا', 'شرق أوروبا', 'شمال افريقيا', 'شمال أمريكا', 'شمال أوروبا', 'شيلي',
        'صربيا', 'صربيا والجبل الأسود',
        'طاجكستان',
        'عمان',
        'غامبيا', 'غانا', 'غرب آسيا', 'غرب افريقيا', 'غرب أوروبا', 'غويانا', 'غيانا', 'غينيا', 'غينيا الاستوائية', 'غينيا بيساو',
        'فانواتو', 'فرنسا', 'فلسطين', 'فنزويلا', 'فنلندا', 'فيتنام', 'فيجي',
        'قبرص', 'قرغيزستان', 'قطر',
        'كازاخستان', 'كاليدونيا الجديدة', 'كرواتيا', 'كمبوديا', 'كندا', 'كوبا', 'كوريا الجنوبية', 'كوريا الشمالية', 'كوستاريكا', 'كولومبيا', 'كومنولث الدول المستقلة', 'كيريباتي', 'كينيا',
        'لاتفيا', 'لاوس', 'لبنان', 'لوكسمبورج', 'ليبيا', 'ليبيريا', 'ليتوانيا', 'ليختنشتاين', 'ليسوتو',
        'مارتينيك', 'ماكاو الصينية', 'مالطا', 'مالي', 'ماليزيا', 'مايوت', 'مدغشقر', 'مصر', 'مقدونيا', 'ملاوي', 'منغوليا', 'موريتانيا', 'موريشيوس', 'موزمبيق', 'مولدافيا', 'موناكو', 'مونتسرات', 'ميانمار', 'ميكرونيزيا', 'ميلانيزيا',
        'ناميبيا', 'نورو', 'نيبال', 'نيجيريا', 'نيكاراجوا', 'نيوزيلاندا', 'نيوي',
        'هايتي', 'هندوراس', 'هولندا', 'هونج كونج الصينية',
        'وسط آسيا', 'وسط افريقيا',
    ];

    protected static $cityFormats = [
        '{{cityName}}',
    ];

    protected static $streetNameFormats = [
        '{{streetPrefix}} {{firstName}} {{lastName}}',
    ];

    protected static $streetAddressFormats = [
        '{{buildingNumber}} {{streetName}}',
        '{{building