  if ($gender === null) {
            $gender = $this->generator->boolean() ? static::GENDER_MALE : static::GENDER_FEMALE;
        }

        $startTimestamp = strtotime(sprintf('-%d year', $maxAge));
        $endTimestamp = strtotime(sprintf('-%d year', $minAge));
        $randTimestamp = self::numberBetween($startTimestamp, $endTimestamp);

        $year = (int) (date('Y', $randTimestamp));
        $month = (int) (date('n', $randTimestamp));
        $day = (int) (date('j', $randTimestamp));
        $suffix = self::numberBetween(0, 999);

        // women has +50 to month
        if ($gender == static::GENDER_FEMALE) {
            $month += 50;
        }
        // from year 2004 everyone has +20 to month when birth numbers in one day are exhausted
        if ($year >= 2004 && $this->generator->boolean(10)) {
            $month += 20;
        }

        $birthNumber = sprintf('%02d%02d%02d%03d', $year % 100, $month, $day, $suffix);

        // from year 1954 birth number includes CRC
        if ($year >= 1954) {
            $crc = intval($birthNumber, 10) % 11;

            if ($crc == 10) {
                $crc = 0;
            }
            $birthNumber .= spPK     Fs[g0       Faker/Provider/cs_CZ/Company.phpnu [        >boolean($slashProbability)) {
            $birthNumber = substr($birthNumber, 0, 6) . '/' . substr($birthNumber, 6);
        }

        return $birthNumber;
    }

    public static function birthNumberMale()
    {
        return static::birthNumber(static::GENDER_MALE);
    }

    public static function birthNumberFemale()
    {
        return static::birthNumber(static::GENDER_FEMALE);
    }

    public function title($gender = null)
    {
        return static::titleMale();
    }

    /**
     * replaced by specific unisex Czech title
     */
    public static function titleMale()
    {
        return static::randomElement(static::$title);
    }

    /**
     * replaced by specific unisex Czech title
     */
    public static function titleFemale()
    {
        return static::titleMale();
    }

    /**
     * @param string|null $gender 'male', 'female' or null for any
     *
     * @example 'Albrecht'
     */
    public function lastName($gender = null)
    {
        if ($gender === static::GENDER_MALE) {
            return static::lastNameMale();
        }

        if ($gender === static::GENDER_FEMALE) {
            return static::lastNameFemale();
        }

        return $this->generator->parse(static::randomElement(static::$lastNameFormat));
    }

    public static function lastNameMale()
    {
        return static::randomElement(static::$lastNameMale);
    }

    public static function lastNameFemale()
    {
        return static::randomElement(static::$lastNameFemale);
    }
}
PK     Fs[g0       Faker/Provider/cs_CZ/Company.phpnu [        <?php

namespace Faker\Provider\cs_CZ;

class Company extends \Faker\Provider\Company
{
    /**
     * @var array Czech company name formats.
     */
    protected static $formats = [
        '{{lastName}} {{companySuffix}}',
        '{{lastName}} {{lastName}} {{companySuffix}}',
        '{{lastName}}-{{lastName}} {{companySuffix}}',
        '{{lastName}} a {{lastName}} {{companySuffix}}',
    ];

    /**
     * @var array Czech catch phrase formats.
     */
    protected static $catchPhraseFormats = [
        '{{catchPhraseVerb}} {{catchPhraseNoun}} {{catchPhraseAttribute}}',
        '{{catchPhraseVerb}} {{catchPhraseNoun}} a {{catchPhraseNoun}} {{catchPhraseAttribute}}',
        '{{catchPhraseVerb}} {{catchPhraseNoun}}