AB', 'PEN', 'PGK', 'PHP', 'PKR', 'PLN', 'PYG',
        'QAR', 'RON', 'RSD', 'RUB', 'RWF', 'SAR', 'SBD', 'SCR', 'SDG', 'SEK',
        'SGD', 'SHP', 'SLL', 'SOS', 'SRD', 'SSP', 'STN', 'SYP', 'SZL', 'THB',
        'TJS', 'TMT', 'TND', 'TOP', 'TRY', 'TTD', 'TWD', 'TZS', 'UAH', 'UGX',
        'USD', 'UYU', 'UZS', 'VES', 'VND', 'VUV', 'WST', 'XAF', 'XCD', 'XOF',
        'XPF', 'YER', 'ZAR', 'ZMW',
    ];

    /**
     * Return a boolean, true or false.
     *
     * @param int $chanceOfGettingTrue Between 0 (always get false) and 100 (always get true)
     *
     * @return bool
     *
     * @example true
     */
    public static function boolean($chanceOfGettingTrue = 50)
    {
        return self::numberBetween(1, 100) <= $chanceOfGettingTrue;
    }

    /**
     * @example 'cfcd208495d565ef66e7dff9f98764da'
     *
     * @return string
     */
    public static function md5()
    {
        return md5(self::numberBetween());
    }

    /**
     * @example 'b5d86317c2a144cd04d0d7c03b2b02666fafadf2'
     *
     * @return string
     */
    public static function sha1()
    {
        return sha1(self::numberBetween());
    }

    /**
     * @example '85086017559ccc40PK     Fs[˪    !  Faker/Provider/cs_CZ/DateTime.phpnu [           */
    public static function sha256()
    {
        return hash('sha256', self::numberBetween());
    }

    /**
     * @example 'fr_FR'
     *
     * @return string
     */
    public static function locale()
    {
        return static::randomElement(static::$localeData);
    }

    /**
     * @example 'FR'
     *
     * @see https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2
     *
     * @return string
     */
    public static function countryCode()
    {
        re