
    {
        return static::iban($countryCode, $prefix, $length);
    }

    /**
     * Value Added Tax (VAT)
     *
     * @example 'BG1234567890', ('spaced') 'BG 1234567890'
     *
     * @see http://ec.europa.eu/taxation_customs/vies/faq.html?locale=en#item_11
     * @see http://en.wikipedia.org/wiki/VAT_identification_number
     *
     * @param bool $spacedNationalPrefix
     *
     * @return string VAT Number
     */
    public static function vat($spacedNationalPrefix = true)
    {
        $prefix = $spacedNationalPrefix ? 'BG ' : 'BG';

        return sprintf(
            '%s%d%d',
            $prefix,
            self::randomNumber(5, true), // workaround for mt_getrandmax() limitation
            self::randomNumber(self::randomElement([4, 5]), true),
        );
    }
}
PK     Fs[^Uك4  4  !  Faker/Provider/bg_BG/Internet.phpnu [        <?php

namespace Faker\Provider\bg_BG;

class Internet extends \Faker\Provider\Internet
{
    protected static $freeEmailDomain = ['gmail.com', 'yahoo.com', 'hotmail.com', 'mail.bg', 'abv.bg', 'dir.bg'];
    protected static $tld = ['bg', 'bg', 'bg', 'bg', 'bg', 'bg', 'com', 'biz', 'info', 'net', 'org'];
}
PK     Fs[gN,  ,    Faker/Provider/de_AT/Person.phpnu [        <?php

namespace Faker\Provider\de_AT;

use Faker\Provider\DateTime;

class Person extends \Faker\Provider\Person
{
    protected static $maleNameFormats = [
        '{{firstNameMale}} {{lastName}}',
        '{{firstNameMale}} {{lastName}}',
        '{{firstNameMale}} {{lastName}}',
        '{{firstNameMale}} {{lastName}}',
        '{{titleMale}} {{firstNameMale}} {{lastName}}',
        '{{firstNameMale}} {{lastName}} {{suffix}}',
        '{{titleMale}} {{firstNameMale}} {{lastName}} {{suffix}}',
    ];

    protected static $femaleNameFormats = [
        '{{firstNameFemale}} {{lastName}}',
        '{{firstNameFemale}} {{lastName}}',
        '{{firstNameFemale}} {{lastName}}',
        '{{firstNameFemale}} {{lastName}}',
        '{{titleFemale}} {{firstNameFemale}} {{lastName}}',
        '{{firstNameFemale}} {{lastName}} {{suffix}}',
        '{{titleFemale}} {{firstNameFemale}} {{lastName}} {{suffix}}',
    ];

    /**
     * 60 most popular names in 1985, 1995, 2005 and 2015
     * {@link} https://www.statistik.at/wcm/idc/idcplg?IdcService=GET_NATIVE_FILE&RevisionSelectionMethod=LatestReleased&dDocName=115199
     */
    protected static $firstNameMale = [
        'Adrian', 'Alexander', 'Andreas', 'Anton',
        'Ben', 'Benedikt', 'Benjamin', 'Bernd', 'Bernhard',
        'Christian', 'Christoph', 'Christopher', 'Clemens',
        'Daniel', 'David', 'Dominik',
        'Elias', 'Emil', 'Erik',
        'Fabian', 'Fabio', 'Felix', 'Finbg', 'bg', 'bg', 'bg', 'com', 'biz', 'info', 'net', 'org'];
}
PK     Fs[gN,  ,    Faker/Provider/de_AT/Person.phpnu [        <?php

namespace Faker\Provider\de_AT;

use Faker\Provider\DateTime;

class Person extends \Faker\Provider\Person
{
    protected static $maleNameFormats = [
        '{{firstNameMale}} {{lastName}}',
        '{{firstNameMale}} {{lastName}}',
        '{{firstNameMale}} {{lastName}}',
        '{{firstNameMale}} {{lastName}}',
        '{{titleMale}} {{firstNameMale}} {{lastName}}',
        '{{firstNameMale}} {{lastName}} {{suffix}}',
        '{{titleMale}} {{firstNameMale}} {{lastName}} {{suffix}}',
    ];

    protected static $femaleNameFormats = [
        '{{firstNameFemale}} {{lastName}}',
        '{{firstNameFemale}} {{lastName}}',
        '{{firstNameFemale}} {{lastName}}',
        '{{firstNameFemale}} {{lastName}}',
        '{{titleFemale}} {{firstNameFemale}} {{lastName}}',
        '{{firstNameFemale}} {{lastName}} {{suffix}}',
        '{{titleFemale}} {{firstNameFemale}} {{lastName}} {{suffix}}',
    ];

    /**
     * 60 most popular names in 1985, 1995, 2005 and 2015
     * {@link} https://www.statistik.at/wcm/idc/idcplg?IdcService=GET_NATIVE_FILE&RevisionSelectionMethod=LatestReleased&dDocName=115199
     */
    protected static $firstNameMale = [
        'Adrian', 'Alexander', 'Andreas', 'Anton',
        'Ben', 'Benedikt', 'Benjamin', 'Bernd', 'Bernhard',
        'Christian', 'Christoph', 'Christopher', 'Clemens',
        'Daniel', 'David', 'Dominik',
        'Elias', 'Emil', 'Erik',
        'Fabian', 'Fabio', 'Felix', 'Finn', 'Florian', 'Franz',
        'Gabriel', 'Georg', 'Gerald', 'Gerhard', 'Gernot', 'Gregor', 'Günther',
        'Hannes', 'Harald', 'Helmut', 'Herbert',
        'Jakob', 'Jan', 'Johann', 'Johannes', 'Jonas', 'Jonathan', 'Josef', 'Joseph', 'Julian', 'Justin', 'Jürgen',
        'Karl', 'Kevin', 'Kilian', 'Klaus', 'Konstantin',
        'Leo', 'Leon', 'Lorenz', 'Luca', 'Luis', 'Lukas',
        'Manfred', 'Manuel', 'Marc', 'Marcel', 'Marco', 'Mario', 'Markus', 'Martin', 'Marvin', 'Matteo', 'Matthias', 'Max', 'Maximilian', 'Michael', 'Moritz',
        'Nico', 'Nicolas', 'Niklas', 'Noah',
        'Oliver', 'Oskar',
        'Pascal', 'Patrick', 'Patrik', 'Paul', 'Peter', 'Philipp',
        'Ralph', 'Raphael', 'Reinhard', 'René', 'Richard', 'Robert', 'Roland', 'Roman',
        'Samuel', 'Sandro', 'Sascha', 'Sebastian', 'Simon', 'Stefan',
        'Theo', 'Theodor', 'Thomas', 'Tim', 'Tobias',
        'Valentin', 'Vincent',
        'Werner', 'Wolfgang',
    ];

    /**
     * 60 most popular names in 1985, 1995, 2005 and 2015
     * {@link} https://www.statistik.at/wcm/idc/idcplg?IdcService=GET_NATIVE_FILE&RevisionSelectionMethod=LatestReleased&dDocName=115199
     */
    protected static $firstNameFemale = [
        'Alexandra', 'Alexandrea', 'Algelika', 'Alina', 'Amelie', 'Andrea', 'Angelina', 'Anita', 'Anja', 'Anna', 'Anna-Lena', 'Annika', 'Astrid',
        'Barbara', 'Bettina', 'Bianca', 'Birgit',
        'Carina', 'Caroline', 'Celina', 'Chiara', 'Christina', 'Christine', 'Clara', 'Claudia', 'Cornelia',
        'Daniela', 'Denise', 'Doris',
        'Elena', 'Elisa', 'Elisabeth', 'Ella', 'Emely', 'Emilia', 'Emily', 'Emma', 'Eva', 'Eva-Maria',
        'Franziska',
        'Hanna', 'Hannah', 'Helena',
        'Ines', 'Iris', 'Isabel', 'Isabella',
        'Jacqueline', 'Jacquline', 'Jana', 'Janine', 'Jasmin', 'Jennifer', 'Jessica', 'Johanna', 'Julia',
        'Karin', 'Katharina', 'Katrin', 'Kerstin',
        'Lara', 'Larissa', 'Laura', 'Lea', 'Lena', 'Leonie', 'Lilly', 'Lina', 'Lisa', 'Livia', 'Luisa',
        'Magdalena', 'Maja', 'Manuela', 'Maria', 'Marie', 'Marion', 'Marlene', 'Martina', 'Melanie', 'Melina', 'Mia', 'Michaela', 'Michelle', 'Miriam', 'Mona', 'Monika',
        'Nadine', 'Natalie', 'Nicole', 'Nina', 'Nora',
        'Patricia', 'Paula', 'Petra', 'Pia',
        'Rebecca', 'Rosa',
        'Sabine', 'Sabrina', 'Sandra', 'Sarah', 'Selina', 'Silvia', 'Simone', 'Sonja', 'Sophia', 'Sophie', 'Stefanie', 'Susanne',
        'Tamara', 'Tanja', 'Theresa',
        'Valentina', 'Valerie', 'Vanessa', 'Verena', 'Viktoria',
        'Yvonne',
    ];

    /**
     * Top 500 Names from a phone directory (February 2004)
     * {@link} https://de.wiktionary.org/w/index.php?title=Verzeichnis:Deutsch/Namen/die_h%C3%A4ufigsten_Nachnamen_%C3%96sterreichs
     */
    protected static $lastName = [
        'Abraham', 'Achleitner', 'Adam', 'Aichinger', 'Aigner', 'Albrecht', 'Altmann', 'Amann', 'Amon', 'Angerer', 'Arnold', 'Artner', 'Aschauer', 'Auer', 'Augustin', 'Auinger',
        'Bacher', 'Bachler', 'Bachmann', 'Bader', 'Baier', 'Barth', 'Bartl', 'Bauer', 'Baumann', 'Baumgartner', 'Bayer', 'Beck', 'Beer', 'Berger', 'Bergmann', 'Bernhard', 'Bichler', 'Binder', 'Bischof', 'Bock', 'Bogner', 'Brandl', 'Brandner', 'Brandstetter', 'Brandstätter', 'Braun', 'Brenner', 'Bruckner', 'Brugger', 'Brunner', 'Buchberger', 'Buchegger', 'Bucher', 'Buchinger', 'Buchner', 'Burger', 'Burgstaller', 'Burtscher', 'Böck', 'Böhm', 'Bösch',
        'Danner', 'Denk', 'Deutsch', 'Dietrich', 'Dobler', 'Doppler', 'Dorner', 'Draxler',
        'Eberharter', 'Eberl', 'Ebner', 'Ecker', 'Eder', 'Edlinger', 'Egger', 'Eibl', 'Eichberger', 'Eichinger', 'Eigner', 'Erhart', 'Ernst', 'Ertl',
        'Falkner', 'Fasching', 'Feichtinger', 'Fellner', 'Fiala', 'Fichtinger', 'Fiedler', 'Fink', 'Fischer', 'Fleischhacker', 'Forster', 'Forstner', 'Frank', 'Franz', 'Friedl', 'Friedrich', 'Fritsch', 'Fritz', 'Fröhlich', 'Frühwirth', 'Fuchs', 'Führer', 'Fürst',
        'Gabriel', 'Gangl', 'Gartner', 'Gasser', 'Gassner', 'Geiger', 'Geisler', 'Geyer', 'Glaser', 'Glatz', 'Gmeiner', 'Grabner', 'Graf', 'Gratzer', 'Greiner', 'Grill', 'Gritsch', 'Gross', 'Groß', 'Gruber', 'Grünwald', 'Gschwandtner', 'Gutmann',
        'Haas', 'Haberl', 'Hackl', 'Hafner', 'Hagen', 'Hager', 'Hahn', 'Haider', 'Haidinger', 'Haller', 'Hammer', 'Hammerl', 'Handl', 'Handler', 'Harrer', 'Hartl', 'Hartmann', 'Haslinger', 'Hauer', 'Hauser', 'Heindl', 'Heinrich', 'Hemetsberger', 'Herbst', 'Hermann', 'Herzog', 'Hinterberger', 'Hinteregger', 'Hinterleitner', 'Hirsch', 'Hochreiter', 'Hofbauer', 'Hofer', 'Hoffmann', 'Hofmann', 'Hofstätter', 'Holzer', 'Holzinger', 'Holzmann', 'Horvath', 'Huber', 'Huemer', 'Hufnagl', 'Humer', 'Hummer', 'Hutter', 'Hämmerle', 'Hödl', 'Höfler', 'Höller', 'Hölzl', 'Hörmann', 'Hütter',
        'Jahn', 'Jandl', 'Janisch', 'Jovanovic', 'Jung', 'Jungwirth', 'Jäger',
        'Kainz', 'Kaiser', 'Kaltenbrunner', 'Kapeller', 'Kargl', 'Karl', 'Karner', 'Kastner', 'Kaufmann', 'Kellner', 'Kern', 'Kerschbaumer', 'Kirchmair', 'Kirchner', 'Klammer', 'Klein', 'Klinger', 'Klug', 'Knapp', 'Knoll', 'Koch', 'Kofler', 'Kogler', 'Kohl', 'Koller', 'Kollmann', 'Konrad', 'Kopp', 'Kovacs', 'Kraft', 'Krainer', 'Kramer', 'Krammer', 'Kraus', 'Kremser', 'Krenn', 'Kreuzer', 'Kronberger', 'Kröll', 'Kugler', 'Kummer', 'Kurz', 'Köberl', 'Köck', 'Köhler', 'König',
        'Lackner', 'Lamprecht', 'Lang', 'Langer', 'Lechner', 'Lederer', 'Leeb', 'Lehner', 'Leitgeb', 'Leitner', 'Lengauer', 'Lenz', 'Lettner', 'Lindner', 'List', 'Loidl', 'Lorenz', 'Ludwig', 'Luger', 'Lukas', 'Lutz', 'Löffler',
        'Mader', 'Maier', 'Maierhofer', 'Mair', 'Mairhofer', 'Mandl', 'Markovic', 'Martin', 'Maurer', 'Mayer', 'Mayerhofer', 'Mayr', 'Mayrhofer', 'Meier', 'Meixner', 'Messner', 'Meyer', 'Mitterer', 'Moosbrugger', 'Moser', 'Muhr', 'Mühlbacher', 'Müller', 'Müllner',
        'Nagl', 'Nemeth', 'Neubauer', 'Neuhauser', 'Neuhold', 'Neumann', 'Neumayer', 'Neuner', 'Neuwirth', 'Nikolic', 'Novak', 'Nowak', 'Nussbaumer', 'Nußbaumer',
        'Ofner', 'Ortner', 'Oswald', 'Ott',
        'Paar', 'Pacher', 'Pammer', 'Paul', 'Payer', 'Peer', 'Penz', 'Peter', 'Petrovic', 'Petz', 'Pfeffer', 'Pfeifer', 'Pfeiffer', 'Pfister', 'Pfleger', 'Pichler', 'Pilz', 'Pinter', 'Pirker', 'Plank', 'Plattner', 'Platzer', 'Pointner', 'Pokorny', 'Pollak', 'Posch', 'Prem', 'Prinz', 'Probst', 'Pucher', 'Putz', 'Pöll', 'Pölzl', 'Pöschl', 'Pühringer',
        'Raab', 'Rabl', 'Rainer', 'Rath', 'Rauch', 'Rausch', 'Rauscher', 'Rauter', 'Rechberger', 'Redl', 'Reich', 'Reichl', 'Reindl', 'Reiner', 'Reinisch', 'Reischl', 'Reisinger', 'Reiter', 'Reiterer', 'Renner', 'Resch', 'Richter', 'Rieder', 'Riedl', 'Riedler', 'Rieger', 'Riegler', 'Rieser', 'Ritter', 'Rosenberger', 'Roth', 'Rupp',
        'Sailer', 'Sattler', 'Sauer', 'Schachinger', 'Schachner', 'Schaffer', 'Schaller', 'Scharf', 'Schatz', 'Schauer', 'Scheiber', 'Schenk', 'Scheucher', 'Schiefer', 'Schiller', 'Schindler', 'Schlager', 'Schlögl', 'Schmid', 'Schmidt', 'Schmied', 'Schnabl', 'Schneeberger', 'Schneider', 'Schober', 'Scholz', 'Sch