 => 'wm',
        'video/x-ms-wmv' => 'wmv',
        'video/x-ms-wmx' => 'wmx',
        'video/x-ms-wvx' => 'wvx',
        'video/x-msvideo' => 'avi',
        'video/x-sgi-movie' => 'movie',
    ];

    /**
     * Get a random MIME type
     *
     * @return string
     *
     * @example 'video/avi'
     */
    public static function mimeType()
    {
        return static::randomElement(array_keys(static::$mimeTypes));
    }

    /**
     * Get a random file extension (without a dot)
     *
     * @example avi
     *
     * @return string
     */
    public static function fileExtension()
    {
        $random_extension = static::randomElement(array_values(static::$mimeTypes));

        return is_array($random_extension) ? static::randomElement($random_extension) : $random_extension;
    }

    /**
     * Copy a random file from the source directory to the target directory and returns the filename/fullpath
     *
     * @param string $sourceDirectory The directory to look for random file taking
     * @param string $targetDirectory
     * @param bool   $fullPath        Whether to have the full path or just the filename
     *
     * @return string
     */
    pubPK     yFs[ )      Faker/Provider/de_CH/Person.phpnu [        $fullPath = true)
    {
        if (!is_dir($sourceDirectory)) {
            throw new \InvalidArgumentException(sprintf('Source directory %s does not exist or is not a directory.', $sourceDirectory));
        }

        if (!is_dir($targetDirectory)) {
            throw new \InvalidArgumentException(sprintf('Target directory %s does not exist or is not a directory.', $targetDirectory));
        }

        if ($sourceDirectory == $targetDirectory) {
            throw new \InvalidArgumentException('Source and target directories must differ.');
        }

        // Drop . and .. and reset array keys
        $files = array_filter(array_values(array_diff(scandir($sourceDirectory), ['.', '..'])), static function ($file) use ($sourceDirectory) {
            return is_file($sourceDirectory . DIRECTORY_SEPARATOR . $file) && is_readable($sourceDirectory . DIRECTORY_SEPARATOR . $file);
        });

        if (empty($files)) {
            throw new \InvalidArgumentException(sprintf('Source directory %s is empty.', $sourceDirectory));
        }

        $sourceFullPath = $sourceDirectory . DIRECTORY_SEPARATOR . static::randomElement($files);

        $destinationFile = Uuid::uuid() . '.' . pathinfo($sourceFullPath, PATHINFO_EXTENSION);
        $destinationFullPath = $targetDirectory . DIRECTORY_SEPARATOR . $destinationFile;

        if (false === copy($sourceFullPath, $destinationFullPath)) {
            return false;
        }

        return $fullPath ? $destinationFullPath : $destinationFile;
    }
}
PK     yFs[ )      Faker/Provider/de_CH/Person.phpnu [        <?php

namespace Faker\Provider\de_CH;

class Person extends \Faker\Provider\de_DE\Person
{
    /**
     * @see http://www.bfs.admin.ch/bfs/portal/de/index/themen/01/02/blank/dos/prenoms/02.html
     */
    protected static $firstNameMale = [
        'Adrian', 'Alain', 'Albert', 'Alessandro', 'Alex', 'Alexander', 'Alfred', 'Ali', 'Alois', 'Andrea', 'Andreas', 'Andrin', 'André', 'Angelo', 'Anton', 'Antonio', 'Armin', 'Arnold', 'Arthur',
        'Beat', 'Benjamin', 'Bernhard', 'Bruno',
        'Carlo', 'Carlos', 'Christian', 'Christoph', 'Claudio', 'Cyrill', 'Cédric',
        'Damian', 'Daniel', 'Dario', 'David', 'Denis', 'Diego', 'Dieter', 'Dominic', 'Dominik',
        'Eduard', 'Elia', 'Elias', 'Emil', 'Eric', 'Erich', 'Ernst', 'Erwin', 'Eugen',
        'Fabian', 'Fabio', 'Felix', 'Flavio', 'Florian', 'Francesco', 'Frank', 'Franz', 'Friedrich', 'Fritz',
        'Gabriel', 'Georg', 'Gerhard', 'Gian', 'Giovanni', 'Giuseppe', 'Guido',
        'Hans', 'Hans-Peter', 'Hanspeter', 'Heinrich', 'Heinz', 'Herbert', 'Hermann', 'Hugo',
        'Ivan', 'Ivo',
        'Jakob', 'Jan', 'Jean', 'Joel', 'Johann', 'Johannes', 'Jonas', 'Jonathan', 'Josef', 'José', 'Joël', 'Julian', 'Jörg', 'Jürg', 'Jürgen',
        'Karl', 'Kevin', 'Kilian', 'Klaus', 'Konrad', 'Kurt',
        'Lars', 'Leandro', 'Leo', 'Leon', 'Levin', 'Livio', 'Lorenz', 'Loris', 'Louis', 'Luca', 'Luigi', 'Luis', 'Lukas',
        'Manfred', 'Manuel', 'Marc', 'Marcel', 'Marco', 'Mario', 'Mark', 'Marko', 'Markus', 'Martin', 'Mathias', 'Matteo', 'Matthias', 'Mauro', 'Max', 'Mehmet', 'Michael', 'Michel', 'Michele', 'Mike', 'Moritz',
        'Nico', 'Nicola', 'Nicolas', 'Niklaus', 'Nils', 'Noah', 'Norbert',
        'Oliver', 'Olivier', 'Othmar', 'Otto',
        'Pascal', 'Patrick', 'Patrik', 'Paul', 'Peter', 'Philip', 'Philipp', 'Philippe', 'Pius',
        'Rafael', 'Rainer', 'Ralf', 'Ralph', 'Ramon', 'Raphael', 'Remo', 'Renato', 'René', 'Reto', 'Richard', 'Robert', 'Roberto', 'Robin', 'Roger', 'Roland', 'Rolf', 'Roman', 'Rudolf',
        'Salvatore', 'Samuel', 'Sandro', 'Sascha', 'Sebastian', 'Severin', 'Silvan', 'Silvio', 'Simon', 'Stefan', 'Stephan', 'Sven',
        'Theodor', 'Thomas', 'Tim', 'Timo', 'Tobias',
        'Ulrich', 'Urs',
        'Walter', 'Werner', 'Wilhelm', 'Willi', 'Willy', 'Wolfgang',
        'Yannick', 'Yves',
    ];

    /**
     * @see http://www.bfs.admin.ch/bfs/portal/de/index/themen/01/02/blank/dos/prenoms/02.html
     */
    protected static $firstNameFemale = [
        'Adelheid', 'Agnes', 'Alessia', 'Alexandra', 'Alice', 'Alina', 'Aline', 'Ana', 'Andrea', 'Angela', 'Angelika', 'Anita', 'Anja', 'Anna', 'Annemarie', 'Antonia', 'Astrid',
        'Barbara', 'Beatrice', 'Beatrix', 'Bernadette', 'Bertha', 'Bettina', 'Brigitta', 'Brigitte',
        'Carla', 'Carmen', 'Caroline', 'Chantal', 'Charlotte', 'Chiara', 'Christa', 'Christina', 'Christine', 'Claudia', 'Corina', 'Corinne', 'Cornelia', 'Céline',
        'Daniela', 'Deborah', 'Denise', 'Diana', 'Dora', 'Doris', 'Dorothea',
        'Edith', 'Elena', 'Eliane', 'Elisabeth', 'Elsa', 'Elsbeth', 'Emma', 'Erika', 'Erna', 'Esther', 'Eva', 'Eveline',
        'Fabienne', 'Fiona', 'Franziska', 'Frieda',
        'Gabriela', 'Gabriele', 'Gertrud', 'Gisela',
        'Hanna', 'Hedwig', 'Heidi', 'Helena', 'Helene', 'Hildegard',
        'Ida', 'Ingrid', 'Irene', 'Iris', 'Irma', 'Isabel', 'Isabella', 'Isabelle',
        'Jacqueline', 'Jana', 'Janine', 'Jasmin', 'Jeannette', 'Jennifer', 'Jessica', 'Johanna', 'Jolanda', 'Judith', 'Julia',
        'Karin', 'Katharina', 'Kathrin', 'Katja', 'Katrin', 'Klara',
        'Lara', 'Larissa', 'Laura', 'Lea', 'Lena', 'Leonie', 'Lina', 'Linda', 'Lisa', 'Liselotte', 'Livia', 'Lorena', 'Luana', 'Lucia', 'Luzia', 'Lydia',
        'Madeleine', 'Magdalena', 'Maja', 'Manuela', 'Mara', 'Margareta', 'Margaretha', 'Margaritha', 'Margrit', 'Margrith', 'Maria', 'Marianna', 'Marianne', 'Marie', 'Marina', 'Marion', 'Marlise', 'Martha', 'Martina', 'Melanie', 'Mia', 'Michaela', 'Michelle', 'Michèle', 'Milena', 'Miriam', 'Mirjam', 'Monica', 'Monika',
        'Nadia', 'Nadine', 'Nadja', 'Natalie', 'Nathalie', 'Nelly', 'Nicole', 'Nina', 'Noemi', 'Nora',
        'Patricia', 'Patrizia', 'Paula', 'Petra', 'Pia', 'Priska',
        'Rahel', 'Ramona', 'Rebecca', 'Regina', 'Regula', 'Renata', 'Renate', 'Rita', 'Rosa', 'Rosmarie', 'Ruth',
        'Sabine', 'Sabrina', 'Sandra', 'Sara', 'Sarah', 'Selina', 'Seraina', 'Sibylle', 'Silvia', 'Simone', 'Sina', 'Sonja', 'Sophie', 'Stefanie', 'Stephanie', 'Susanna', 'Susanne', 'Sylvia',
        'Tamara', 'Tanja', 'Therese', 'Theresia',
        'Ursula',
        'Valentina', 'Vanessa', 'Vera', 'Verena', 'Veronika',
        'Yvonne',
    ];

    /**
     * @see http://blog.tagesanzeiger.ch/datenblog/index.php/6859
     */
    protected static $lastName = [
        'Achermann', 'Ackermann', 'Aeschlimann', 'Ammann', 'Arnold',
        'Bachmann', 'Baumann', 'Baumgartner', 'Beck', 'Benz', 'Berger', 'Betschart', 'Bieri', 'Bischof', 'Blaser', 'Blum', 'Bolliger', 'Bosshard', 'Brunner', 'Bucher', 'Burri', 'Bärtschi', 'Bösch', 