ode}} ### ####',
        '0 {{mobileCode}} ### ####',
    ];

    /**
     * @see https://en.wikipedia.org/wiki/List_of_dialling_codes_in_Germany
     *
     * @return string
     */
    public static function areaCode()
    {
        $firstDigit = self::numberBetween(2, 9);

        return $firstDigit . self::regexify(self::$areaCodeRegexes[$firstDigit]);
    }

    /**
     * Generate a code for a mobile number.
     *
     * @internal Used to generate mobile numbers.
     *
     * @return string
     */
    public static function mobileCode()
    {
        return static::randomElement(static::$mobileCodes);
    }

    /**
     * Generate a mobile number.
     *
     * @example A mobile number: '015111234567'
     * @example A mobile number with spaces: '01511 123 4567'
     * @example A mobile number with international code prefix: '+4915111234567'
     * @example A mobile number with international code prefix and spaces: '+49 1511 123 4567'
     *
     * @return string
     */
    public function mobileNumber()
    {
        return ltrim(static::numerify($this->generator->parse(
            static::randomElement(static::$mobileFormats),
        )));
    }
}
PK     YFs[       Faker/Provider/de_DE/Payment.phpnu [        <?php

namespace Faker\Provider\de_DE;

class Payment extends \Faker\Provider\Payment
{
    /**
     * International Bank Account Number (IBAN)
     *
     * @see http://en.wikipedia.org/wiki/International_Bank_Account_Number
     *
     * @param string $prefix      for generating bank account number of a specific bank
     * @param string $countryCode ISO 3166-1 alpha-2 country code
     * @param int    $length      total length without country code and 2 check digits
     *
     * @return string
     */
    public static function bankAccountNumber($prefix = '', $countryCode = 'DE', $length = null)
    {
        return static::iban($countryCode, $prefix, $length);
    }

    /**
     * Sources:
     * The 19 largest German banks by total assets
     *
     * @see https://de.wikipedia.org/wiki/Liste_der_größten_Banken_in_Deutschland
     * The 20 largest co-operative banks by branch count
     * @see https://de.wikipedia.org/wiki/Liste_der_Genossenschaftsbanken_in_Deutschland
     * The 20 largest public savings banks by branch count
     * @see https://de.wikipedia.org/wiki/Liste_der_Sparkassen_in_Deutschland
     */
    protected static $banks = [
        'Bank 1 Saar', 'Bayerische Landesbank', 'BBBank', 'Berliner Sparkasse', 'Berliner Volksbank', 'Braunschweigische Landessparkasse',
        'Commerzbank',
        'DekaBank Deutsche Girozentrale', 'Deutsche Apotheker- und Ärztebank', 'Deutsche Bank', 'Deutsche Kreditbank', 'Deutsche Pfandbriefbank', 'Dortmunder Volksbank', 'DZ Bank',
        'Erzgebirgssparkasse',
        'Frankfurter Sparkasse', 'Frankfurter Volksbank',
        'Hamburger Sparkasse', 'Hannoversche Volksbank', 'HSGV', 'HSH Nordbank',
        'ING-DiBa',
        'KfW', 'Kreissparkasse Esslingen-Nürtingen', 'Kreissparkasse Hei