Phillips', 'Powell', 'Price',
        'Reid', 'Reynolds', 'Richards', 'Richardson', 'Roberts', 'Robertson', 'Robinson', 'Rogers', 'Rose', 'Ross', 'Russell',
        'Saunders', 'Scott', 'Shaw', 'Simpson', 'Smith', 'Stevens', 'Stewart',
        'Taylor', 'Thomas', 'Thompson', 'Turner',
        'Walker', 'Walsh', 'Ward', 'Watson', 'White', 'Wilkinson', 'Williams', 'Wilson', 'Wood', 'Wright',
        'Young',
    ];

    /**
     * Generates a random National Insurance number.
     *
     * @see https://www.gov.uk/hmrc-internal-manuals/national-insurance-manual/nim39110
     */
    public function nino(): string
    {
        $prefixAllowList = ['A', 'B', 'C', 'E', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'R', 'S', 'T', 'W', 'X', 'Y', 'Z'];
        $prefixBanList = ['BG', 'GB', 'KN', 'NK', 'NT', 'TN', 'ZZ'];

        do {
            $prefix = implode('', self::randomElements($prefixAllowList, 2, true));
        } while (in_array($prefix, $prefixBanList, false) || $prefix[1] == 'O');

        $digits = static::numerify('######');
        $suffix = static::randomElement(['A', 'B', 'C', 'D']);

        return sprintf('%s%s%s', $prefix, $digits, $suffix);
    }
}
PK     Fs[m
  
     Faker/Provider/en_GB/Company.phpnu [        <?php

namespace Faker\Provider\en_GB;

class Company extends \Faker\Provider\Company
{
    public const VAT_PREFIX = 'GB';
    public const VAT_TYPE_DEFAULT = 'vat';
    public const VAT_TYPE_BRANCH = 'branch';
    public const VAT_TYPE_GOVERNMENT = 'gov';
    public const VAT_TYPE_HEALTH_AUTHORITY = 'health';

    /**
     * UK VAT number
     *
     * This method produces numbers that are _reasonably_ representative
     * of those issued by government
     *
     * @see https://en.wikipedia.org/wiki/VAT_identification_number#VAT_numbers_by_country
     */
    public static function vat(string $type = null): string
    {
        switch ($type) {
            case static::VAT_TYPE_BRANCH:
                return static::generateBranchTraderVatNumber();

            case static::VAT_TYPE_GOVERNMENT:
                return static::generateGovernmentVatNumber();

            case static::VAT_TYPE_HEALTH_AUTHORITY:
                return static::generateHealthAuthorityVatNumber();

            default:
                return static::generateStandardVatNumber();
        }
    }

    /**
     * Standard
     * 9 digits (block of 3, block of 4, block of 2)
     *
     * This uses the format introduced November 2009 onward where the first
     * block starts from 100 and the final two digits are generated via a the
     * modulus 9755 algorithm
     */
    private static function generateStandardVatNumber(): string
    {
        $firstBlock = static::numberBetween(100, 999);
        $secondBlock = static::randomNumber(4, true);

        return sprintf(
            '%s%d %d %d',
            static::VAT_PREFIX,
            $firstBlock,
            $secondBlock,
            static::calculateModulus97($firstBlock . $secondBlock),
        );
    }

    /**
     * Health authorities
     * the letters HA then 3 digits from 500 to 999 (e.g. GBHA599)
     */
    private static function generateHealthAuthorityVatNumber(): string
    {
        return sprintf(
            '%sHA%d',
            static::VAT_PREFIX,
            static::numberBetween(500, 999),
        );
    }

    /**
     * Branch traders
     * 12 digits (as for 9 digits, followed by a block of 3 digits)
     */
    private static function generateBranchTraderVatNumber(): string
    {
        retu