          static::randomNumber(3, true),
        );
    }

    /**
     * Government departments
     * the letters GD then 3 digits from 000 to 499 (e.g. GBGD001)
     */
    private static function generateGovernmentVatNumber(): string
    {
        return sprintf(
            '%sGD%s',
            static::VAT_PREFIX,
            str_pad((string) static::numberBetween(0, 499), 3, '0', STR_PAD_LEFT),
        );
    }

    /**
     * Apply a Modulus97 algorithm to an input
     *
     * @see https://library.croneri.co.uk/cch_uk/bvr/43-600
     */
    public static function calculateModulus97(string $input, bool $use9755 = true): string
    {
        $digits = str_split($input);

        if (count($digits) !== 7) {
            throw new \InvalidArgumentException();
        }
        $multiplier = 8;
        $sum = 0;

        foreach ($digits as $digit) {
            $sum += (int) $digit * $multiplier;
            --$multiplier ;
        }

        if ($use9755) {
            $sum = $sum + 55;
        }

        