firstName}} {{citySuffix}}',
        '{{lastName}} {{citySuffix}}',
    ];
    protected static $streetNameFormats = [
        '{{streetPrefix}} {{firstName}} {{lastName}}',
    ];
    protected static $streetAddressFormats = [
        '{{streetName}} # {{buildingNumber}} ',
        '{{streetName}} # {{buildingNumber}} {{secondaryAddress}}',
    ];
    protected static $addressFormats = [
        "{{streetAddress}}\n{{city}}, {{state}}",
    ];
    protected static $secondaryAddressFormats = ['Dpto. ###', 'Hab. ###', 'Piso #', 'Piso ##'];

    /**
     * @example ''
     */
    public static function cityPrefix()
    {
        return static::randomElement(static::$cityPrefix);
    }

    /**
    PK     YFs[hZU    !  Faker/Provider/en_HK/Internet.phpnu [         return static::randomElement(static::$streetPrefix);
    }

    /**
     * @example 'Dpto. 402'
     */
    public static function secondaryAddress()
    {
        return static::numerify(static::randomElement(static::$secondaryAddressFormats));
    }

    /**
     * @example 'Lima'
     */
    public static function state()
    {
        return static::randomElement(static::$state);
    }
PK     YFs[vÑ&  &     Faker/Provider/en_HK/Address.phpnu [              <?php

namespace Faker\Provider\en_HK;

class PhoneNumber extends \Faker\Provider\PhoneNumber
{
    protected static $formats = ['2#######', '3#######', '5#######', '6#######', '9#######'];
    protected static $mobileFormats = ['5#######', '6#######', '9#######'];
    protected static $landlineFormats = ['2#######', '3#######'];
    protected static $faxFormats = ['7#######'];

    /**
     * Return an en_HK mobile phone number
     *
     * @return string
     */
    public static function mobileNumber()
    {
        return static::numerify(static::randomElement(static::$mobileFormats));
    }

    /**
     * Return an en_HK landline number
     *
     * @return string
     */
    public static function landlineNumber()
    {
        return static::numerify(static::randomElement(static::$landlineFormats));
    }

    /**
     * Return an en_HK fax number
     *
     * @return string
     */
    public static function faxNumber()
    {
        return static::numerify(static::randomElement(static::$faxFormats));
    }
}
PK     YFs[hZU    !  Faker/Provider/en_HK/Internet.phpnu [        <?php

namespace Faker\Provider\en_HK;

class Internet extends \Faker\Provider\Internet
{
    protected static $freeEmailDomain = [
        'gmail.com', 'yahoo.com', 'hotmail.com', 'yahoo.com.hk', 'hotmail.com.hk',
    ];
    protected static $tld = [
        'com', 'com', 'com', 'com.hk', 'com.hk', 'com', 'biz', 'info', 'net', 'org',
        'com.hk', 'edu.hk', 'org.hk', 'idv.hk',
    ];
}
PK     YFs[vÑ&  &     Faker/Provider/en_HK/Address.phpnu [        <?php

namespace Faker\Provider\en_HK;

class Address extends \Faker\Provider\Address
{
    protected static $country = ['Hong Kong'];

    protected static $syllables = [
        'A', 'Ai', 'Ak', 'Am', 'An', 'Ang', 'Ap', 'At', 'Au',
        'Cha', 'Chai', 'Chak', 'Cham', 'Chan', 'Chang', 'Chap', 'Chat', 'Chau',
        'Che', 'Chek', 'Cheng', 'Cheuk', 'Cheung',
        'Chi', 'Chik', 'Chim', 'Chin', 'Ching', 'Chip', 'Chit', 'Chiu',
        'Cho', 'Choi', 'Chok', 'Chong', 'Chou',
        'Chue', 'Chuen', 'Chuet', 'Chui', 'Chuk', 'Chun', 'Chung', 'Chut',
        'E', 'Ei',
        'Fa', 'Fai', 'Fak', 'Fan', 'Fang', 'Fat', 'Fau',
        'Fe', 'Fei', 'Fo', 'Fok', 'Fong',
        'Fu', 'Fui', 'Fuk', 'Fun', 'Fung', 'Fut',
        'Ha', 'Hai', 'Hak', 'Ham', 'Han', 'Hang', 'Hap', 'Hat', 'Hau',
        'Hei', 'Hek', 'Heng', 'Heu', 'Heung',
        'Hik', 'Him', 'Hin', 'Hing', 'Hip', 'Hit', 'Hiu',
        'Ho', 'Hoi', 'Hok', 'Hon', 'Hong', 'Hot', 'Hou',
        'Huen', 'Huet', 'Hui', 'Huk', 'Hung',
        'Ka', 'Kai', 'Kak', 'Kam', 'Kan', 'Kang', 'Kap', 'Kat', 'Kau',
        'Ke', 'Kei', 'Kek', 'Keng', 'Keu', 'Keuk', 'Keung',
        'Kik', 'Kim', 'Kin', 'King', 'Kip', 'Kit', 'Kiu',
        'Ko', 'Koi', 'Kok', 'Kon', 'Kong', 'Kot', 'Kou',
        'Ku', 'Kuhi', 'Shik', 'Shim', 'Shin', 'Shing', 'Ship', 'Shit', 'Shiu',
        'Sho', 'Shoi', 'Shok', 'Shong', 'Shou',
        'Shue', 'Shuen', 'Shuet', 'Shui', 'Shuk', 'Shun', 'Shung', 'Shut',
        'Sik', 'Sim', 'Sin', 'Sing', 'Sip', 'Sit', 'Siu',
        'So', 'Soi', 'Sok', 'Song', 'Sou',
        'Sue', 'Suen', 'Suet', 'Sui', 'Suk', 'Sun', 'Sung', 'Sut',
        'Sze',
        'Ta', 'Tai', 'Tak', 'Tam', 'Tan', 'Tang', 'Tap', 'Tat', 'Tau',
        'Te', 'Tei', 'Tek', 'Teng', 'Teu', 'Teuk',
        'Tik', 'Tim', 'Tin', 'Ting', 'Tip', 'Tit', 'Tiu',
        'To', 'Toi', 'Tok', 'Tong', 'Tou',
        'Tsa', 'Tsai', 'Tsak', 'Tsam', 'Tsan', 'Tsang', 'Tsap', 'Tsat', 'Tsau',
        'Tse', 'Tsek', 'Tseng', 'Tseuk', 'Tseung',
        'Tsik', 'Tsim', 'Tsin', 'Tsing', 'Tsip', 'Tsit', 'Tsiu',
        'Tso', 'Tsoi', 'Tsok', 'Tsong', 'Tsou',
        'Tsue', 'Tsuen', 'Tsuet', 'Tsui', 'Tsuk', 'Tsun', 'Tsung', 'Tsut',
        'Tsz',
        'Tuen', 'Tuet', 'Tui', 'Tuk', 'Tun', 'Tung', 'Tut',
        'Uk', 'Ung',
        'Wa', 'Wai', 'Wak', 'Wan', 'Wang', 'Wat',
        'Wik', 'Wing',
        'Wo', 'Wok', 'Wong', 'Wu',
        'Wui', 'Wun', 'Wut', 'Ya',
        'Yai', 'Yak', 'Yam', 'Yan', 'Yap', 'Yat', 'Yau',
        'Ye', 'Yeng', 'Yeuk', 'Yeung', 'Yi',
        'Yik', 'Yim', 'Yin', 'Ying', 'Yip', 'Yit', 'Yiu',
        'Yo',
        'Yue', 'Yuen', 'Yuet', 'Yui', 'Yuk', 'Yun', 'Yung',
    ];

    protected static $streetAddressFormats = [
        '{{buildingNumber}} {{streetName}}',
        '{{buildingNumber}} {{village}}',
        'Block {{buildingNumber}}, {{estate}}',
    ];

    protected static $addressFormats = [
        "{{streetAddress}}\n{{town}}\n{{city}}",
    ];

    protected static $villageNameFormats = [
        '{{syllable}} {{syllable}} {{villageSuffix}}',
        '{{syllable}} {{syllable}} {{villageSuffix}}',
        '{{syllable}} {{syllable}} {{villageSuffix}}',
        '{{syllable}} {{syllable}} {{villageSuffix}}',
        '{{syllable}} {{syllable}} {{villageSuffix}}',
        '{{syllable}} {{syllable}} {{villageSuffix}}',
        '{{syllable}} {{syllable}} {{villageSuffix}}',
        '{{syllable}} {{syllable}} {{syllable}} {{villageSuffix}}',
        '{{syllable}} {{syllable}} {{syllable}} {{villageSuffix}}',
        '{{syllable}} {{syllable}} {{syllable}} {{villageSuffix}}',
        '{{syllable}} {{syllable}} {{syllable}} {{villageSuffix}}',
        '{{syllable}} {{syllable}} {{syllable}} {{villageSuffix}}',
        '{{syllable}} {{syllable}} {{syllable}} {{villageSuffix}}',
        '{{syllable}} {{syllable}} {{syllable}} {{villageSuffix}}',
        '{{syllable}} {{syllable}} {{syllable}} {{villageSuffix}}',
        '{{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}} {{syllable}}',
        '{{town}}',
        '{{town}} {{villageSuffix}}',
    ];

    protected static $estateNameFormats = [
        '{{syllable}} {{syllable}} {{estateSuffix}}',
        '{{syllable}} {{syllable}} {{estateSuffix}}',
        '{{syllable}} {{syllable}} {{estateSuffix}}',
        '{{syllable}} {{syllable}} {{syllable}} {{estateSuffix}}',
        '{{syllable}} {{syllable}} {{syllable}} {{estateSuffix}}',
        '{{syllable}} {{syllable}} {{syllable}} {{estateSuffix}}',
        '{{town}} {{estateSuffix}}',
    ];

    protected static $villageSuffixes = ['Village', 'Tsuen', 'San Tsuen', 'New Village', 'Wai'];

    protected static $estateSuffixes = ['Estate', 'Court'];

    protected static $streetNameFormats = [
        '{{syllable}} {{streetSuffix}}',
        '{{syllable}} {{syllable}} {{streetSuffix}}',
        '{{syllable}} {{syllable}} {{streetSuffix}}',
        '{{syllable}} {{syllable}} {{streetSuffix}}',
        '{{syllable}} {{syllable}} {{syllable}} {{streetSuffix}}',
        '{{syllable}} {{syllable}} {{syllable}} {{streetSuffix}}',
        '{{syllable}} {{syllable}} {{syllable}} {{streetSuffix}}',
        '{{syllable}} {{syllable}} {{direction}} {{streetSuffix}}',
        '{{syllable}} {{syllable}} {{syllable}} {{direction}} {{streetSuffix}}',
        '{{syllable}} {{syllable}} {{streetSuffix}} {{direction}}',
        '{{syllable}} {{syllable}} {{syllable}} {{streetSuffix}} {{direction}}',
        '{{englishStreetName}} {{streetSuffix}}',
        '{{englishStreetName}} {{streetSuffix}} {{direction}}',
    ];

    protected static $englishStreetNames = [
        "King's", "Queen's", 'Nathan', 'Robinson', 'Kingston', 'Irving', 'Bonham', 'Salisbury',
        'Tonkin', 'Nanking', 'Peking', 'Canton', 'Amoy', 'Shanghai',
    ];

    protected static $streetSuffix = [
        'Road', 'Road', 'Road', 'Street', 'Street', 'Street', 'Lane',
        'Circuit', 'Avenue', 'Path', 'Square',
    ];

    protected static $directions = ['North', 'East', 'South', 'West'];

    protected static $cities = ['Hong Kong', 'Kowloon', 'New Territories'];

    protected static $towns = [
        '{{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}} {{syllable}}',
        '{{syllable}} {{syllable}} {{syl