oreach (['status', 'inbound'] as $type) {
            $key = $type . '_url';

            if (isset($array[$key])) {
                $method = $array[$type . '_method'] ?? null;
                $application->getMessagesConfig()->setWebhook($key, new Webhook($array[$key], $method));
            }
        }

        // RTC
        foreach (['event'] as $type) {
            $key = $type . '_url';

            if (isset($array[$key])) {
                $method = $array[$type . '_method'] ?? null;
                $application->getRtcConfig()->setWebhook($key, new Webhook($array[$key], $method));
            }
        }

        // VBC
        if (isset($array['vbc']) && $array['vbc']) {
            $application->getVbcConfig()->enable();
        }

        return $application;
    }

    /**
     * @throws Exception
     */
    protected function createFromArrayV2(array $array): Application
    {
        foreach (['name',] as $param) {
            if (!isset($array[$param])) {
                throw new InvalidArgumentException('missing expected key `' . $param . '`');
            }
        }

        $application = new Application();
        $application->fromArray($PK     CFs[       Faker/Provider/en_SG/Address.phpnu [        blic key?
        if (isset($array['keys']['public_key'])) {
            $application->setPublicKey($array['keys']['public_key']);
        }

        // How about capabilities?
        if (!isset($array['capabilities'])) {
            return $application;
        }

        $capabilities = $array['capabilities'];

        // Handle voice
        if (isset($capabilities['voice'])) {
            $voiceCapabilities = $capabilities['voice']['webhooks'];

            foreach (['answer', 'event'] as $type) {
                $application->getVoiceConfig()->setWebhook($type . '_url', new Webhook(
                    $voiceCapabilities[$type . '_url']['address'],
                    $voiceCapabilities[$type . '_url']['http_method']
                ));
            }
        }

        // Handle messages
        if (isset($capabilities['messages'])) {
            $messagesCapabilities = $capabilities['messages']['webhooks'];

            foreach (['status', 'inbound'] as $type) {
                $application->getMessagesConfig()->setWebhook($type . '_url', new Webhook(
                    $messagesCapabilities[$type . '_url']['address'],
                    $messagesCapabilities[$type . '_url']['http_method']
                ));
            }
        }

        // Handle RTC
        if (isset($capabilities['rtc'])) {
            $rtcCapabilities = $capabilities['rtc']['webhooks'];

            foreach (['event'] as $type) {
                $application->getRtcConfig()->setWebhook($type . '_url', new Webhook(
                    $rtcCapabilities[$type . '_url']['address'],
                    $rtcCapabilities[$type . '_url']['http_method']
                ));
            }
        }

        // Handle VBC
        if (isset($capabilities['vbc'])) {
            $application->getVbcConfig()->enable();
        }

        return $application;
    }
}
PK     t[x#  #    Application/Application.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Application;

use Exception;
use JsonSerializable;
use StdClass;
use Vonage\Entity\EntityInterface;
use Vonage\Entity\Hydrator\ArrayHydrateInterface;
use Vonage\Entity\JsonResponseTrait;
use Vonage\Entity\JsonSerializableTrait;
use Vonage\Entity\JsonUnserializableInterface;
use Vonage\Entity\Psr7Trait;

use fu