 public const METHOD_GET = 'GET';

    public ?string $socketTimeout = null;

    public ?string $connectionTimeout = null;

    public function __construct(protected ?string $url, protected ?string $method = self::METHOD_POST)
    {
    }

    public function getMethod(): ?string
    {
        return $this->method;
    }

    public function getUrl(): ?string
    {
        return $this->url;
    }

    public function __toString(): string
    {
        return $this->getUrl();
    }

    public function getSocketTimeout(): ?string
    {
        return $this->socketTimeout;
    }

    public function setSocketTimeout(?string $socketTimeout): static
    {
        $this->socketTimeout = $socketTimeout;

        return $this;
    }

    public function getConnectionTimeout(): ?string
    {
        return $this->connectionTimeout;
    }

    public function setConnectionTimeout(?string $connectionTimeout): static
    {
        $this->connectionTimeout = $connectionTimeout;

        return $this;
    }
}
PK     t[$z$  $    Application/Hydrator.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 VonagPK     CFs[S<
  
  $  Faker/Provider/en_SG/PhoneNumber.phpnu [        e/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Application;

use Exception;
use InvalidArgumentException;
use Vonage\Entity\Hydrator\HydratorInterface;

class Hydrator implements HydratorInterface
{
    /**
     * @throws Exception
     */
    public function hydrate(array $data): Application
    {
        $application = new Application();
        return $this->hydrateObject($data, $application);
    }

    /**
     * @throws Exception
     */
    public function hydrateObject(array $data, $object): Application
    {
        if (isset($data['answer_url']) || isset($data['event_url'])) {
            return $this->createFromArrayV1($data, $object);
        }

        return $this->createFromArrayV2($data);
    }

    protected function createFromArrayV1(array $array, $application): Application
    {
        foreach (['name',] as $param) {
            if (!isset($array[$param])) {
                throw new InvalidArgumentException('missing expected key `' . $param . '`');
            }
        }

        $application->setName($array['name']);

        // Public key?
        if (isset($array['public_key'])) {
            $application->setPublicKey($array['public_key']);
        }

        // Voice
        foreach (['event', 'answer'] as $type) {
            $key = $type . '_url';

            if (isset($array[$key])) {
                $method = $array[$type . '_method'] ?? null;
                $application->getVoiceConfig()->setWebhook($key, new Webhook