request
     *
     * @param $length
     *
     * @throws Exception
     *
     * @return RequestArrayTrait|Verification
     */
    public function setCodeLength($length)
    {
        return $this->setRequestData('code_length', $length);
    }

    /**
     * By default, TTS are generated in the locale that matches number. For example, the TTS for a 33* number is sent in
     * French. Use this parameter to explicitly control the language, accent and gender used for the Verify request. The
     * default language is en-us.
     *
     * Can only be set before the verification is created.
     *
     * @link https://developer.nexmo.com/verify/overview#vrequest
     *
     * @param $language
     *
     * @throws Exception
     *
     * @return RequestArrayTrait|Verification
     */
    public function setLanguage($language)
    {
        return $this->setRequestData('lg', $language);
    }

    /**
     * Restrict verification to a certain network type. Possible values are:
     * - All (Default)
     * - Mobile
     * - Landline
     *
     * Note: contact support@vonage.com to enable this feature.
     *
     * Can only be set before the verification is creaPK     EFs[XÎ1  1     Faker/Provider/es_VE/Company.phpnu [           *
     * @param $type
     *
     * @throws Exception
     *
     