ace;

use function array_key_exists;
use function strlen;

class Request implements ArrayHydrateInterface
{
    public const PIN_LENGTH_4 = 4;
    public const PIN_LENGTH_6 = 6;

    public const WORKFLOW_SMS_TTS_TSS = 1;
    public const WORKFLOW_SMS_SMS_TSS = 2;
    public const WORKFLOW_TTS_TSS = 3;
    public const WORKFLOW_SMS_SMS = 4;
    public const WORKFLOW_SMS_TTS = 5;
    public const WORKFLOW_SMS = 6;
    public const WORKFLOW_TTS = 7;

    /**
     * @var string
     */
    protected $country;

    /**
     * @var string
     */
    protected $senderId = 'VERIFY';

    /**
     * @var int
     */
    protected $codeLength = 4;

    /**
     * @var string
     */
    protected $locale;

    /**
     * @var int
     */
    protected $pinExpiry = 300;

    /**
     * @var int
     */
    protected $nextEventWait = 300;

    /**
     * @var int
     */
    protected $workflowId = 1;

    public function __construct(protected string $number, protected string $brand, int $workflowId = 1)
    {
        $this->setWorkflowId($workflowId);
    }

    public function getCountry(): ?string
    {
        return $this->country;
    }

    /**
     * @return $this
PK     EFs[o$l5  l5    Faker/Provider/es_VE/Person.phpnu [        (strlen($country) !== 2) {
            throw new InvalidArgumentException('Country must be in two character format');
        }

        $this->country = $country;

        return $this;
    }

    public function getSenderId(): string
    {
        return $this->senderId;
    }

    /**
     * @return $this
     */
    public function setSenderId(string $senderId): self
    {
        $this->senderId = $senderId;

        return $this;
    }

    public function getCodeLength(): int
    {
        return $this->codeLength;
    }

    /**
     * @return $this
     */
    public function setCodeLength(int $codeLength): self
    {
        if ($codeLength !== self::PIN_LENGTH_4 && $codeLength !== self::PIN_LENGTH_6) {
            throw new InvalidArgumentException(
                sprintf('Pin length must be either %d or %d digits', self::PIN_LENGTH_4, self::PIN_LENGTH_6)
            );
        }

        $this->codeLength = $codeLength;

        return $this;
    }

    public function getLocale(): ?string
    {
        return $this->locale;
    }

    /**
     * @return $this
     */
    public function setLocale(string $locale): self
    {
        $this->locale = $locale;

        return $this;
    }

    public function getPinExpiry(): int
    {
        return $this->pinExpiry;
    }

    /**
     * @return $this
     */
    public function setPinExpiry(int $pinExpiry): self
    {
        if ($pinExpiry < 60 || $pinExpiry > 3600) {
            throw new InvalidArgumentException('Pin expiration must be between 60 and 3600 seconds');
        }

        $this->pinExpiry = $pinExpiry;

        return $this;
    }

    public function getNextEventWait(): int
    {
        return $this->nextEventWait;
    }

    /**
     * @return $this
     */
    public function setNextEventWait(int $nextEventWait): self
    {
        if ($nextEventWait < 60 || $nextEventWait > 3600) {
            throw new InvalidArgumentException('Next Event time must be between 60 and 900 seconds');
        }

        $this->nextEventWait = $nextEventWait;

        return $this;
    }

    public function getWorkflowId(): int
    {
        return $this->workflowId;
    }

    /**
     * @return $this
     */
    public function setWorkflowId(int $workflowId): self
    {
        if ($workflowId < 1 || $workflowId > 7) {
            throw new InvalidArgumentException('Workflow ID must be from 1 to 7');
        }

        $this->workflowId = $workflowId;

        return $this;
    }

    public function getNumber(): string
    {
        return $this->number;
    }

    public function getBrand(): string
    {
        return $this->brand;
    }

    public function fromArray(array $data): void
    {
        if (array_key_exists('sender_id', $data)) {
            $this->setSenderId($data['sender_id']);
        }

        if (array_key_exists('code_length', $data)) {
            $this->setCodeLength($data['code_length']);
        }

        if (array_key_exists('pin_expiry', $data)) {
            $this->setPinExpiry($data['pin_expiry']);
        }

        if (array_key_exists('next_event_wait', $data)) {
            $this->setNextEventWait($data['next_event_wait']);
        }

        if (array_key_exists('workflow_id', $data)) {
            $this->setWorkflowId($data['workflow_id']);
        }

        if (array_key_exists('country', $data)) {
            $this->setCountry($data['country']);
        }

        if (array_key_exists('lg', $data)) {
            $this->setLocale($data['lg']);
        }
    }

    public function toArray(): array
    {
        $data = [
            'number' => $this->getNumber(),
            'brand' => $this->getBrand(),
            'sender_id' => $this->getSenderId(),
            'code_length' => $this->getCodeLength(),
            'pin_expiry' => $this->getPinExpiry(),
            'next_event_wait' => $this->getNextEventWait(),
            'workflow_id' => $this->getWorkflowId()
        ];

        if ($this->getCountry()) {
            $data['country'] = $this->getCountry();
        }

        if ($this->getLocale()) {
            $data['lg'] = $this->getLocale();
        }

        return $data;
    }
}
PK     t[~#G  #G    Verify/Verification.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Verify;

use DateTime;
use Exception;
use Laminas\Diactoros\Request\Serializer as RequestSerializer;
use Laminas\Diactoros\Response\Serializer as ResponseSerializer;
use Psr\Http\Client\ClientExceptionInterface;
use RuntimeException;
use Serializable;
use Vonage\Client\Exception\Exception as ClientException;
use Vonage\Client\Exception\Request as RequestException;
use Vonage\Client\Exception\Server as ServerException;
use Vonage\Entity\Hydrator\ArrayHydrateInterface;
use Vonage\Entity\JsonResponseTrait;
use Vonage\Entity\Psr7Trait;
use Vonage\Entity\RequestArrayTrait;

use function array_merge;
use function get_class;
use function is_null;
use function serialize;
use function sprintf;
use function trigger_error;
use function unserialize;

/**
 * Serializable interface is deprecated and will be removed in the future
 */
class Verification implements VerificationInterface, Serializable, ArrayHydrateInterface
{
    use Psr7Trait;

    /**
     * @deprecated
     */
    use RequestArrayTrait;
    use JsonResponseTrait;

    /**
     * Possible verification statuses.
     */
    public const FAILED = 'FAILED';
    public const SUCCESSFUL = 'SUCCESSFUL';
    public const EXPIRED = 'EXPIRED';
    public const IN_PROGRESS = 'IN PROGRESS';

    protected $dirty = true;

    /**
     * @deprecated Use the Vonage\Verify\Client instead to interact with the API
     *
     * @var Client;
     */
    protected $client;

    /**
     * Verification constructor.
     *
     * Create a verification with a number and brand, or the `request_id` of an existing verification.
     * Note that in the future, this constructor will accept only the ID as the first parameter.
     *
     * @param $idOrNumber
     * @param $brand
     * @param array $additional
     */
    public function __construct($idOrNumber, $brand = null, array $additional = [])
    {
        if (is_null($brand)) {
            $this->dirty = false;
            $this->requestData['request_id'] = $idOrNumber;
        } else {
            trigger_error(
                'Using ' . $this::class . ' for starting a verification is deprecated, ' .
                'please use Vonage\Verify\Request instead',
                E_USER_DEPRECATED
            );

            $this->dirty = true;
            $this->requestData['number'] = $idOrNumber;
            $this->requestData['brand'] = $brand;
            $this->requestData = array_merge($this->requestData, $additional);
        }
    }

    /**
     * Allow Verification to have actions.
     *
     * @param Client $client Verify Client
     *
     * @return $this
     *
     * @deprecated Use the Vonage\Verification\Client service object directly
     */
    public function setClient(Client $client): self
    {
        trigger_error(
            'Setting a client directly on a Verification object is deprecated, ' .
            'please use the Vonage\Verification\Client service object directly',
            E_USER_DEPRECATED
        );

        $this->client = $client;

        return $this;
    }

    /**
     * @deprecated Use the Vonage\Verification\Client service object directly
     */
    protected function useClient(): ?Client
    {
        if (isset($this->client)) {
            return $this->client;
        }

        throw new RuntimeException('can not act on the verification directly unless a verify client has been set');
    }

    /**
     * Check if the code is correct. Unlike the method it proxies, an invalid code does not throw an exception.
     *
     * @param $code
     * @param $ip
     *
     * @throws ClientException
     * @throws RequestException
     * @throws ServerException
     * @throws ClientExceptionInterface
     */
    public function check($code, $ip = null): ?bool
    {
        trigger_error(
            'Vonage\Verify\Verification::check() is deprecated, use Vonage\Verification\Client::check()',
            E_USER_DEPRECATED
        );
        try {
            if (null !== $this->useClient()) {
                $this->useClient()->check($this, $code, $ip);

                return true;
            }

            return false;
        } catch (RequestException $e) {
            $code = $e->getCode();

            if ($code === 16 || $code === 17) {
                return false;
            }

            throw $e;
        }
    }

    /**
     * Cancel the verification.
     *
     * @throws ClientExceptionInterface
     * @throws ClientException
     * @throws RequestException
     * @throws ServerException
     *
     * @deprecated Use Vonage\Verification\Client::cancel()
     */
    public function cancel(): void
    {
        trigger_error(
            'Vonage\Verify\Verification::cancel() is deprecated, use Vonage\Verification\Client::cancel()',
            E_USER_DEPRECATED
        );

        if (null !== $this->useClient()) {
            $this->useClient()->cancel($this);
        }
    }

    /**
     * Trigger the next verification.
     *
     * @throws ClientExceptionInterface
     * @throws ClientException
     * @throws RequestException
     * @throws ServerException
     *
     * @deprecated Use Vonage\Verification\Client::trigger()
     */
    public function trigger(): void
    {
        trigger_error(
            'Vonage\Verify\Verification::trigger() is deprecated, use Vonage\Verification\Client::trigger()',
            E_USER_DEPRECATED
        );

        if (null !== $this->useClient()) {
            $this->useClient()->trigger($this);
        }
    }

    /**
     * Update Verification from the API.
     *
     * @throws ClientExceptionInterface
     * @throws ClientException
     * @throws RequestException
     * @throws ServerException
     *
     * @deprecated Use Vonage\Verification\Client::get() to retrieve the object directly
     */
    public function sync(): void
    {
        trigger_error(
            'Vonage\Verify\Verification::sync() is deprecated, ' .
            'use Vonage\Verification\Client::search() to get a new copy of this object',
            E_USER_DEPRECATED
        );

        if (null !== $this->useClient()) {
            $this->useClient()->search($this);
        }
    }

    /**
     * Check if the user provided data has sent to the API yet
     *
     * @deprecated This object will not hold this information in the future
     */
    public function isDirty(): bool
    {
        trigger_error(
            'Vonage\Verify\Verification::isDirty() is deprecated',
            E_USER_DEPRECATED
        );

        return $this->dirty;
    }

    /**
     * If do not set number in international format or you are not sure if number is correctly formatted, set country
     * with the two-character country code. For example, GB, US. Verify works out the international phone number for
     * you.
     *
     * Can only be set before the verification is created.
     *
     * @link https://developer.nexmo.com/verify/overview#vrequest
     *
     * @param $country
     *
     * @throws Exception
     *
     * @return RequestArrayTrait|Verification
     */
    public function setCountry($country)
    {
        return $this->setRequestData('country', $country);
    }

    /**
     * An 11 character alphanumeric string to specify the SenderID for SMS sent by Verify. Depending on the destination
     * of the phone number you are applying, restrictions may apply. By default, sender_id is VERIFY.
     *
     * Can only be set before the verification is created.
     *
     * @link https://developer.nexmo.com/verify/overview#vrequest
     *
     * @param $id
     *
     * @throws Exception
     *
     * @return RequestArrayTrait|Verification
     */
    public function setSenderId($id)
    {
        return $this->setRequestData('sender_id', $id);
    }

    /**
     * The length of the PIN. Possible values are 6 or 4 characters. The default value is 4.
     *
     * Can only be set before the verificati