000';

        while ($area == '000') {
            $area = static::numerify('###');
        }

        return $area;
    }

    /**
     * This method randomly generates a 6-digit core code for nationalCode
     *
     * @return string
     */
    private static function createCoreCode()
    {
        return static::numerify('######');
    }

    /**
     * This method uses the Iranian nationalCode validation algorithm to generate a valid 10-digit code
     *
     * @param string $area
     * @param string $core
     *
     * @see https://fa.wikipedia.org/wiki/%DA%A9%D8%A7%D8%B1%D8%AA_%D8%B4%D9%86%D8%A7%D8%B3%D8%A7%DB%8C%DB%8C_%D9%85%D9%84%DB%8C#%D8%AD%D8%B3%D8%A7%D8%A8_%DA%A9%D8%B1%D8%AF%D9%86_%DA%A9%D8%AF_%DA%A9%D9%86%D8%AA%D8%B1%D9%84
     *
     * @return int
     */
    private static function createControlCode($area, $core)
    {
        $subNationalCodeString = $area . $core;

        $sum = 0;
        $count = 0;

        for ($i = 10; $i > 1; --$i) {
            $sum += $subNationalCodeString[$count] * ($i);
            ++$count;
        }

        if (($sum % 11) < 2) {
            return $sum % 11;
        }

        return 11 - ($sum % 11);
    }
}
PK     {Fs[TS}n       Faker/Provider/fa_IR/Company.phpnu [        <?php

namespace Faker\Provider\fa_IR;

class Company extends \Faker\Provider\Company
{
    protected static $formats = [
        '{{companyPrefix}} {{companyField}} {{firstName}}',
        '{{companyPrefix}} {{companyField}} {{firstName}}',
        '{{companyPrefix}} {{companyField}} {{firstName}}',
        '{{companyPrefix}} {{companyField}} {{firstName}}',
        '{{companyPrefix}} {{companyField}} {{lastName}}',
        