lioja', 'Väyrynen', 'Väätänen',
        'Wettenranta', 'Wiitanen', 'Wirtanen', 'Wiskari',
        'Ylijälä', 'Yliannala', 'Ylijoki', 'Ylikangas', 'Ylioja', 'Ylitalo', 'Ylppö', 'Yläjoki', 'Yrjänen', 'Yrjänä', 'Yrjölä', 'Yrttiaho', 'Yömaa',
        'Äijälä', 'Ämmälä', 'Änäkkälä', 'Äyräs', 'Äärynen',
        'Översti', 'Öysti', 'Öörni',
    ];

    protected static $titleMale = ['Hra.', 'Tri.'];

    protected static $titleFemale = ['Rva.', 'Nti.', 'Tri.'];

    /**
     * National Personal Identity Number (Henkilötunnus)
     *
     * @see http://www.finlex.fi/fi/laki/ajantasa/2010/20100128
     *
     * @param \DateTime $birthdate
     * @param string    $gender    Person::GENDER_MALE || Person::GENDER_FEMALE
     *
     * @return string on format DDMMYYCZZZQ, where DDMMYY is the date of birth, C the century sign, ZZZ the individual number and Q the control character (checksum)
     */
    public function personalIdentityNumber(\DateTime $birthdate = null, $gender = null)
    {
        $checksumCharacters = '0123456789ABCDEFHJKLMNPRSTUVWXY';

        if (!$birthdate) {
            $birthdate = \Faker\Provider\DateTime::dateTimeThPK     Fs[)K       Faker/Provider/fi_FI/Company.phpnu [        witch ((int) ($birthdate->format('Y') / 100)) {
            case 18:
                $centurySign = '+';

                break;

            case 19:
                $centurySign = '-';

                break;

            case 20:
                $centurySign = 'A';

                break;

            default:
                throw new \InvalidArgumentException('Year must be between 1800 and 2099 inclusive.');
        }

        $randomDigits = self::numberBetween(0, 89);

        if ($gender && $gender == static::GENDER_MALE) {
            if ($randomDigits === 0) {
                $randomDigits .= static::randomElement([3, 5, 7, 9]);
            } else {
                $randomDigits .= static::randomElement([1, 3, 5, 7, 9]);
            }
        } elseif ($gender && $gender == static::GENDER_FEMALE) {
            if ($randomDigits === 0) {
                $randomDigits .= static::randomElement([2, 4, 6, 8]);
            } else {
                $randomDigits .= static::randomElement([0, 2, 4, 6, 8]);
            }
        } else {
            if ($randomDigits === 0) {
                $randomDigits .= self::numberBetween(2, 9);
            } else {
                $randomDigits .= (string) static::numerify('#');
            }
        }
        $randomDigits = str_pad($randomDigits, 3, '0', STR_PAD_LEFT);

        $checksum = $checksumCharacters[(int) ($datePart . $randomDigits) % strlen($checksumCharacters)];

        return $datePart . $centurySign . $randomDigits . $checksum;
    }
}
PK     Fs[)K       Faker/Provider/fi_FI/Company.phpnu [        <?php

namespace Faker\Provider\fi_FI;

class Company extends \Faker\Provider\Company
{
    protected static $formats = [
        '{{lastName}} {{companySuffix}}',
        '{{lastName}}-{{lastName}}',
        '{{lastName}}, {{lastName}} and {{lastName}}',
    ];

    protected static $catchPhraseWords = [
        [
            'Ainoa', 'Adaptiivinen', 'Automatisoitu', 'Avoin', 'Avoimen lähdekoodin', 'Digitalisoitu', 'Dynaaminen', 'Erikoistunut', 'Ennakoiva', 'Ergonominen', 'Hallittu', 'Hajautettu', 'Horisontaalinen', 'Integroitu', 'Innovatiivinen', 'Jaettava', 'Keskittynyt', 'Käyttäjäystävällinen', 'Laajenettu', 'Laajennettava', 'Lievittävä', 'Maailmanlaajuinen', 'Muokattava', 'Monitoroitu', 'Monikerroksinen', 'Ohjelmoitava', 'Optimoitu', 'Organisoitu', 'Orgaaninen', 'Rinnastettava', 'Räätälöitävä', 'Saumaton', 'Tasapainotettava', 'Täysin yhteensopiva', 'Yhteensopiva', 'Yksinomainen', 'Vaiheittainen', 'Virtuaalinen', 'Visionäärinen', 'Valinnainen', 'Verkostoitunut',
        ],
        [
            '24/7', '3. sukupolven', '4. sukupolven', '5. sukupolven', '6. sukupolven', 'alueellinen', 'analysoiva', 'assymmetrinen', 'asynkroninen', 'asiakaslähtöinen', 'dynaaminen', 'globaali', 'heuristinen', 'hybridi', 'inkrementaalinen', 'interaktiivinen', 'kahtiajakautuva', 'kaksisuuntainen', 'konkreettinen', 'korkean tason', 'logistinen', 'johdonmukainen', 'maksimaalinen', 'moniajettava', 'multimedia', 'optimaalinen', 