uffix = ['S.Ked', 'S.Gz', 'S.Pt', 'S.IP', 'S.E.I',
        'S.E.', 'S.Kom', 'S.H.', 'S.T.', 'S.Pd', 'S.Psi', 'S.I.Kom',
        'S.Sos', 'S.Farm', 'M.M.', 'M.Kom.', 'M.TI.', 'M.Pd', 'M.Farm', 'M.Ak', ];

    /**
     * Return last name
     *
     * @param string|null $gender male or female or null for any
     *
     * @return string last name
     */
    public function lastName($gender = null)
    {
        if ($gender === static::GENDER_MALE) {
            return static::lastNameMale();
        }

        if ($gender === static::GENDER_FEMALE) {
            return static::lastNameFemale();
        }
        $lastNameRandomElement = static::randomElement(static::$lastNameFormat);

        return $this->generator->parse($lastNameRandomElement);
    }

    /**
     * Return last name for male
     *
     * @return string last name
     */
    public static function lastNameMale()
    {
        return static::randomElement(static::$lastNameMale);
    }

    /**
     * Return last name for female
     *
     * @return string last name
     */
    public static function lastNameFemale()
    {
        return static::randomElement(static::$lastNameFemale);
    }

  PK     Fs[t1
  
     Faker/Provider/id_ID/Company.phpnu [        public static function suffix()
    {
        return static::randomElement(static::$suffix);
    }

    /**
     * Generates Nomor Induk Kependudukan (NIK)
     *
     * @see https://en.wikipedia.org/wiki/National_identification_number#Indonesia
     *
     * @param string|null    $gender
     * @param \DateTime|null $birthDate
     *
     * @return string
     */
    public function nik($gender = null, $birthDate = null)
    {
        // generate first numbers (region data)
        $nik = $this->birthPlaceCode();
        $nik .= $this->generator->numerify('##');

        if (!$birthDate) {
            $birthDate = $this->generator->dateTimeBetween();
        }

        if (!$gender) {
            $gender = $this->generator->randomElement([self::GENDER_MALE, self::GENDER_FEMALE]);
        }

        // if gender is female, add 40 to days
        if ($gender == self::GENDER_FEMALE) {
            $nik .= $birthDate->format('d') + 40;
        } else {
            $nik .= $birthDate->format('d');
        }

        $nik .= $birthDate->format('my');

        // add last random digits
        $nik .= $this->generator->numerify('####');

        return $nik;
    }

    /**
     * Generates birth place code for NIK
     *
     * @see https://id.wikipedia.org/wiki/Nomor_Induk_Kependudukan
     * @see http://informasipedia.com/wilayah-indonesia/daftar-kabupaten-kota-di-indonesia/
     */
    protected function birthPlaceCode()
    {
        return static::randomElement(static::$birthPlaceCode);
    }
}
PK   