ction bank()
    {
        return static::randomElement(static::$banks);
    }

    /**
     * International Bank Account Number (IBAN)
     *
     * @see http://en.wikipedia.org/wiki/International_Bank_Account_Number
     *
     * @param string $prefix      for generating bank account number of a specific bank
     * @param string $countryCode ISO 3166-1 alpha-2 country code
     * @param int    $length      total length without country code and 2 check digits
     *
     * @return string
     */
    public static function bankAccountNumber($prefix = '', $countryCode = 'GE', $length = null)
    {
        return static::iban($countryCode, $prefix, $length);
    }
}
PK     Fs[9    !  Faker/Provider/ka_GE/Internet.phpnu [        <?php

namespace Faker\Provider\ka_GE;

class Internet extends \Faker\Provider\Internet
{
    protected static $freeEmailDomain = [
        'posta.ge', 'boom.ge', 'hotmail.com', 'gmail.com', 'yahoo.com', 'mail.ru', 'avoe.ge',
    ];

    protected static $tld = [
        'ge', 'ge', 'ge', 'ge', 'ge', 'com.ge', 'edu.ge', 'net.ge', 'org.ge',
        'pvt.ge', 'gov.ge', 'mil.ge', 'com', 'biz', 'info', 'net', 'org',
    ];
}
PK     Fs[jeI:  :     Faker/Provider/ka_GE/Address.phpnu [        <?php

namespace Faker\Provider\ka_GE;

class Address extends \Faker\Provider\Address
{
    protected static $cityPrefix = ['ქალაქი', 'ქ.'];

    protected static $regionSuffix = ['რაიონი'];
    protected static $streetSuffix = [
        'ჩიხი', 'ქ.', 'გამზირი', 'ქუჩა', 'გზატკეცილი', 'მოედანი', 'ბულვარი',
        'აღმართი', 'ხეივანი',
    ];

    protected static $buildingNumber = ['%#'];
    protected static $postcode = ['####'];
    protected static $country = [
        'ავსტრალია', 'ავსტრია', 'ავღანეთი', 'აზერბაიჯანი', 'ალანდის კუნძულები', 'ალბანეთი',
        'ალჟირი', 'ამერიკის სამოა', 'ანგილია', 'ანგოლა', 'ანდორა', 'ანტარქტიდა', 'ანტიგუა და ბარბუდა',
        'არაბთა გაერთიანებული საამიროები', 'არგენტინა', 'არუბა', 'აღმოსავლეთი ტიმორი', 'აშშ',
        'აშშ-ის მიმდებარე მცირე კუნძულები', 'ახალი ზელანდია', 'ახალი კალედონია', 'ბანგლადეში',
        'ბარბადოსი', 'ბაჰამის კუნძულები', 'ბაჰრეინი', 'ბელარუსი', 'ბელგია', 'ბელიზი', 'ბენინი',
        'ბერმუდის კუნძულები', 'ბოლივია', 'ბოსნია და ჰერცეგოვინა', 'ბოტსვანა', 'ბრაზილია',
        'ბრუნეი დარუსალამი', 'ბუვე', 'ბულგარეთი', 'ბურკინა-ფასო', 'ბურუნდი', 'ბჰუტანი', 'გაბონი',
        'გაერთიანებული სამეფო', 'გაიანა', 'გამბია', 'განა', 'გერმანია', 'გერნზი', 'გვადელუპა', 'გვატემალა',
        'გვინეა', 'გვინეა-ბისაუ', 'გიბრალტარი', 'გრენადა', 'გრენლანდია', 'გუამი', 'დანია', 'დასავლეთი საჰარა',
        'დომინიკა', 'დომინიკელთა რესპუბლიკა', 'ეგვიპტე', 'ეთიოპია', 'ეკვადორი', 'ეკვატორული გვინეა', 'ერაყი',
        'ერიტრეა', 'ესპანეთი', 'ესტონეთი', 'ვანუატუ', 'ვატიკანი (წმინდა საყდარი)', 'ვენესუელა', 'ვიეტნამი',
        'ვირჯინის კუნძულები (აშშ-ის)', 'ვირჯინის კუნძულები (ბრიტანეთის)', 'ზამბია', 'ზიმბაბვე', 'თურქეთი',
        'თურქმენეთი', 'იამაიკა', 'იაპონია', 'იემენი', 'ინდოეთი', 'ინდონეზია', 'იორდანია',
        'ირანის მუსულმანური რესპუბლიკა', 'ირლანდია', 'ისლანდია', 'ისრაელი', 'იტალია', 'კაბო-ვერდე',
        'კაიმანის კუნძულები', 'კამბოჯა', 'კამერუნი', 'კანადა', 'კატარი', 'კენია', 'კვიპროსი', 'კირიბატი',
        'კოლუმბია', 'კომორის კუნძულების კავშირი', 'კონგო', 'კონგოს დემოკრატიული რესპუბლიკა', 'კოსტა-რიკა',
        'კოტ-დ’ივუარი', 'კუბა', 'კუკის კუნძულები', 'კუნძული მენი', 'ლაოსის სახალხო დემოკრატიული რესპუბლიკა',
        'ლატვია', 'ლესოთო', 'ლიბანი', 'ლიბერია', 'ლიბიის არაბული ჯამაჰირია', 'ლიტვა', 'ლიხტენშტაინი',
        'ლუქსემბურგი', 'მადაგასკარი', 'მავრიკი', 'მავრიტანია', 'მაიოტა', 'მაკაო', 'მაკედონია', 'მალავი',
        'მალაიზია', 'მალდივი', 'მალი', 'მალტა', 'მაროკო', 'მარტინიკა', 'მარშალის კუნძულები', 'მექსიკა',
        'მიანმარი', 'მიკრონეზიის ფედერაციული შტატები', 'მოზამბიკი', 'მოლდოვას რესპუბლიკა', 'მონაკო', 'მონსერატი',
        'მონღოლეთი', 'ნამიბია', 'ნაურუ', 'ნეპალი', 'ნიგერი', 'ნიგერია', 'ნიდერლანდი', 'ნიდერლანდის ანტილები',
        'ნიკარაგუა', 'ნიუე', 'ნორვეგია', 'ნორფოლკი (კუნძული)', 'ომანი', 'პაკისტანი', 'პალაუ',
        'პალესტინის ტერიტორიები, ოკუპირებული', 'პანამა', 'პაპუა-ახალი გვინეა', 'პარაგვაი', 'პერუ',
        'პიტკერნის კუნძულები', 'პოლონეთი', 'პორტუგალია', 'პუერტო-რიკო', 'რეიუნ      'ლუქსემბურგი', 'მადაგასკარი', 'მავრიკი', 'მავრიტანია', 'მაიოტა', 'მაკაო', 'მაკედონია', 'მალავი',
        'მალაიზია', 'მალდივი', 'მალი', 'მალტა', 'მაროკო', 'მარტინიკა', 'მარშალის კუნძულები', 'მექსიკა',
        'მიანმარი', 'მიკრონეზიის ფედერაციული შტატები', 'მოზამბიკი', 'მოლდოვას რესპუბლიკა', 'მონაკო', 'მონსერატი',
        'მონღოლეთი', 'ნამიბია', 'ნაურუ', 'ნეპალი', 'ნიგერი', 'ნიგერია', 'ნიდერლანდი', 'ნიდერლანდის ანტილები',
        'ნიკარაგუა', 'ნიუე', 'ნორვეგია', 'ნორფოლკი (კუნძული)', 'ომანი', 'პაკისტანი', 'პალაუ',
        'პალესტინის ტერიტორიები, ოკუპირებული', 'პანამა', 'პაპუა-ახალი გვინეა', 'პარაგვაი', 'პერუ',
        'პიტკერნის კუნძულები', 'პოლონეთი', 'პორტუგალია', 'პუერტო-რიკო', 'რეიუნიონი', 'რუანდა', 'რუმინეთი',
        'რუსეთი', 'საბერძნეთი', 'სალვადორი', 'სამოა', 'სამხრეთი აფრიკა',
        'სამხრეთი გეორგია და სამხრეთ სენდვიჩის კუნძულები', 'სამხრეთი კორეა', 'სან-მარინო', 'სან-ტომე და პრინსიპი',
        'საუდის არაბეთი', 'საფრანგეთი', 'საფრანგეთის გვიანა', 'საფრანგეთის პოლინეზია',
        'საფრანგეთის სამხრეთული და ანტარქტიდული ტერიტორია', 'საქართველო', 'სეიშელი', 'სენ-ბართელმი',
        'სენ-პიერი და მიკელონი', 'სენეგალი', 'სენტ-ვინსენტი და გრენადინები', 'სენტ-კიტსი და ნევისი',
        'სენტ-ლუსია', 'სერბეთი', 'სვაზილენდი', 'სვალბარდი და იან-მაიენი', 'სიერა-ლეონე', 'სინგაპური',
        'სირიის არაბთა რესპუბლიკა', 'სლოვაკეთი', 'სლოვენია', 'სოლომონის კუნძულები', 'სომალი', 'სომხეთი', 'სუდანი',
        'სურინამი', 'ტაივანი', 'ტაილანდი', 'ტანზანიის გაერთიანებული რესპუბლიკა', 'ტაჯიკეთი',
        'ტერქსისა და კაიკოსის კუნძულები', 'ტოგო', 'ტოკელაუ', 'ტონგა', 'ტრინიდადი და ტობაგო', 'ტუვალუ', 'ტუნისი',
        'უგანდა', 'უზბეკეთი', 'უკრაინა', 'უნგრეთი', 'უოლისი და ფუტუნა', 'ურუგვაი', 'ფარერის კუნძულები', 'ფილიპინები',
        'ფინეთი', 'ფიჯი', 'ფოლკლენდის კუნძულები (მალვინები)', 'ქოქოსის კუნძულები', 'ქუვეითი', 'ყაზახეთი', 'ყირგიზეთი',
        'შვედეთი', 'შვეიცარია', 'შობის კუნძული', 'შრი-ლანკა', 'ჩადი', 'ჩერნოგორია', 'ჩეხეთი', 'ჩილე', 'ჩინეთი',
        'ჩრდილოეთი კორეა', 'ჩრდილოეთი მარიანას კუნძულები', 'ცენტრალური აფრიკის რესპუბლიკა', 'წმინდა ელენეს კუნძული',
        'წმინდა მარტინი (საფრანგეთის ნაწილი)', 'ხორვატია', 'ჯერზი', 'ჯიბუტი', 'ჰაიტი',
        'ჰერდი და მაკდონალდის კუნძულები', 'ჰონგ-კონგი', 'ჰონდურასი',
    ];

    protected static $region = [
        'აფხაზეთი', 'აჭარა', 'იმერეთი', 'სამეგრელო-ზემო სვანეთი', 'მცხეთა-მთიანეთი', 'სამცხე-ჯავახეთი',
        'შიდა ქართლი', 'კახეთი', 'რაჭა-ლეჩხუმი და ქვემო სვანეთი', 'გურია', 'ქვემო ქართლი',
    ];

    protected static $regionGenitiveForm = [
        'აფხაზეთის', 'აჭარის', 'იმერეთის', 'სამეგრელო-ზემო სვანეთის', 'მცხეთა-მთიანეთის', 'სამცხე-ჯავახეთის',
        'შიდა ქართლის', 'კახეთის', 'რაჭა-ლეჩხუმი და ქვემო სვანეთის', 'გურიის', 'ქვემო ქართლის',
    ];

    protected static $city = [
        'აბაშა', 'ამბროლაური', 'ახალი ათონი', 'ახალქალაქი', 'ახალციხე', 'ახმეტა', 'ბათუმი', 'ბაღდათი',
        'ბოლნისი', 'ბორჯომი', 'გაგრა', 'გალი', 'გარდაბანი', 'გორი', 'გუდაუთა', 'გურჯაანი', 'დედოფლისწყარო',
        'დმანისი', 'დუშეთი', 'ვალე', 'ვანი', 'ზესტაფონი', 'ზუგდიდი', 'თბილისი', 'თეთრიწყარო', 'თელავი',
        'თერჯოლა', 'კასპი', 'ლაგოდეხი', 'ლანჩხუთი', 'მარნეული', 'მარტვილი', 'მცხეთა', 'ნინოწმინდა', 'ოზურგეთი',
        'ონი', 'ოჩამჩირე', 'რუსთავი', 'საგარეჯო', 'სამტრედია', 'საჩხერე', 'სენაკ