стем',
        'Фахир',
        'Хұсайын',
        'Шілдебай',
        'Ыстамбақы',
        'Ісмет',
    ];

    /**
     * Note! When calculating individual identification number
     *   2000-01-01 - 2000-12-31 counts as 21th century
     *   1900-01-01 - 1900-12-31 counts as 20th century
     *
     * @param int $year
     *
     * @return int
     */
    private static function getCenturyByYear($year)
    {
        if (($year >= 2100) || ($year < 1800)) {
            throw new \InvalidArgumentException('Unexpected century');
        }

        if ($year >= 2000) {
            return self::CENTURY_21ST;
        }

        if ($year >= 1900) {
            return self::CENTURY_20TH;
        }

        return self::CENTURY_19TH;
    }

    /**
     * National Individual Identification Numbers
     *
     * @see   http://egov.kz/wps/portal/Content?contentPath=%2Fegovcontent%2Fcitizen_migration%2Fpassport_id_card%2Farticle%2Fiin_info&lang=en
     * @see   https://ru.wikipedia.org/wiki/%D0%98%D0%BD%D0%B4%D0%B8%D0%B2%D0%B8%D0%B4%D1%83%D0%B0%D0%BB%D1%8C%D0%BD%D1%8B%D0%B9_%D0%B8%D0%B4%D0%B5%D0%BD%D1%82%D0%B8%D1%84%D0%B8%D0%BA%D0%BPK     zFs[h	  	     Faker/Provider/kk_KZ/Company.phpnu [        *
     * @param \DateTime $birthDate
     * @param int       $gender
     *
     * @return string 12 digits, like 780322300455
     */
    public static function individualIdentificationNumber(\DateTime $birthDate = null, $gender = self::GENDER_MALE)
    {
        if (!$birthDate) {
            $birthDate = DateTime::dateTimeBetween();
        }

        do {
            $population = self::numberBetween(1000, 2000);
            $century = self::getCenturyByYear((int) $birthDate->format('Y'));

            $iin = $birthDate->format('ymd');
            $iin .= (string) self::$genderCenturyMap[$gender][$century];
            $iin .= (string) $population;
            $checksum = self::checkSum($iin);
        } while ($checksum === 10);

        return $iin . (string) $checksum;
    }

    /**
     * @param string $iinValue
     *
     * @return int
     */
    public static function checkSum($iinValue)
    {
        $controlDigit = self::getControlDigit($iinValue, self::$firstSequenceBitWeights);

        if ($controlDigit === 10) {
            return self::getControlDigit($iinValue, self::$secondSequec function company()
    {
        $format = static::randomElement(static::$companyNameFormats);

        return $this->generator->parse($format);
    }

    public static function c